/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.java;

import dev.latvian.mods.rhino.util.HideFromJS;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import moe.wolfgirl.probejs.ProbeConfig;
import moe.wolfgirl.probejs.lang.java.clazz.ClassPath;
import moe.wolfgirl.probejs.lang.java.clazz.Clazz;
import moe.wolfgirl.probejs.lang.java.clazz.members.ConstructorInfo;
import moe.wolfgirl.probejs.lang.java.clazz.members.FieldInfo;
import moe.wolfgirl.probejs.lang.java.clazz.members.MethodInfo;
import moe.wolfgirl.probejs.lang.java.clazz.members.ParamInfo;
import moe.wolfgirl.probejs.lang.java.type.TypeDescriptor;
import moe.wolfgirl.probejs.lang.java.type.impl.VariableType;

@HideFromJS
public class ClassRegistry {
    public static final ClassRegistry REGISTRY = new ClassRegistry();
    private final Map<ClassPath, Clazz> foundClasses = new HashMap<ClassPath, Clazz>();

    public void putClass(ClassPath classPath, Clazz clazz) {
        if (classPath.getName().contains("-")) {
            return;
        }
        this.foundClasses.put(classPath, clazz);
    }

    public void fromClazz(Collection<Clazz> classes) {
        for (Clazz c : classes) {
            if (this.foundClasses.containsKey(c.classPath)) continue;
            this.putClass(c.classPath, c);
        }
    }

    public void fromClasses(Collection<Class<?>> classes, int recursionDepth) {
        for (Class<?> c : classes) {
            try {
                Class.forName(c.getName());
            }
            catch (Throwable ignore) {
                continue;
            }
            try {
                if (c.isSynthetic() || c.isAnonymousClass() || this.foundClasses.containsKey(new ClassPath(c))) continue;
                Clazz clazz = new Clazz(c);
                clazz.recursionDepth = recursionDepth;
                this.putClass(clazz.classPath, clazz);
            }
            catch (Throwable throwable) {}
        }
    }

    private Set<Class<?>> retrieveClass(Clazz clazz) {
        HashSet classes = new HashSet();
        for (ConstructorInfo constructor : clazz.constructors) {
            for (ParamInfo param : constructor.params) {
                classes.addAll(param.type.getClasses());
            }
            for (VariableType variableType : constructor.variableTypes) {
                classes.addAll(variableType.getClasses());
            }
        }
        for (MethodInfo method : clazz.methods) {
            for (ParamInfo param : method.params) {
                classes.addAll(param.type.getClasses());
            }
            for (VariableType variableType : method.variableTypes) {
                classes.addAll(variableType.getClasses());
            }
            classes.addAll(method.returnType.getClasses());
        }
        for (FieldInfo field : clazz.fields) {
            classes.addAll(field.type.getClasses());
        }
        for (VariableType variableType : clazz.variableTypes) {
            classes.addAll(variableType.getClasses());
        }
        if (clazz.superClass != null) {
            classes.addAll(clazz.superClass.getClasses());
        }
        for (TypeDescriptor i : clazz.interfaces) {
            classes.addAll(i.getClasses());
        }
        return classes;
    }

    public void discoverClasses() {
        HashSet<Clazz> currentClasses = new HashSet<Clazz>(this.foundClasses.values());
        int recursion = 1;
        while (!currentClasses.isEmpty()) {
            HashSet<Class> fetchedClass = new HashSet<Class>();
            for (Clazz currentClass : currentClasses) {
                fetchedClass.addAll(this.retrieveClass(currentClass));
            }
            fetchedClass.removeIf(clazz -> this.foundClasses.containsKey(new ClassPath((Class<?>)clazz)));
            currentClasses.clear();
            for (Class c : fetchedClass) {
                try {
                    Class.forName(c.getName());
                    Clazz clazz2 = new Clazz(c);
                    clazz2.recursionDepth = recursion;
                    this.putClass(clazz2.classPath, clazz2);
                    currentClasses.add(clazz2);
                }
                catch (Throwable throwable) {}
            }
            ++recursion;
        }
    }

    public Collection<Clazz> getFoundClasses() {
        int allowedDepth = ProbeConfig.INSTANCE.recursionDepth.get();
        return this.foundClasses.values().stream().filter(clazz -> clazz.recursionDepth <= allowedDepth).filter(clazz -> !clazz.classPath.getName().contains("package-info")).collect(Collectors.toSet());
    }

    public void writeTo(Path path) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (Map.Entry<ClassPath, Clazz> entry : this.foundClasses.entrySet()) {
                writer.write("%s\t%s\n".formatted(entry.getKey().getClassPathJava(), entry.getValue().recursionDepth));
            }
        }
    }

    public void loadFrom(Path path) {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            for (String parts : reader.lines()::iterator) {
                try {
                    String[] classRecursion = parts.split("\t");
                    Class<?> loaded = Class.forName(classRecursion[0]);
                    this.fromClasses(Collections.singleton(loaded), Integer.parseInt(classRecursion[1]));
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

