/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.decompiler;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import moe.wolfgirl.probejs.lang.decompiler.parser.ParsedDocument;
import moe.wolfgirl.probejs.lang.java.clazz.ClassPath;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;

public class ProbeFileSaver
implements IResultSaver {
    public final Map<ClassPath, ParsedDocument> result = new HashMap<ClassPath, ParsedDocument>();
    private Runnable callback;
    public int classCount = 0;

    public void saveFolder(String path) {
    }

    public void copyFile(String source, String path, String entryName) {
    }

    public void saveClassFile(String path, String qualifiedName, String entryName, String content, int[] mapping) {
        String[] parts = qualifiedName.split("/");
        parts[parts.length - 1] = "$" + parts[parts.length - 1];
        ClassPath classPath = new ClassPath(List.of(parts));
        this.result.put(classPath, new ParsedDocument(content));
        ++this.classCount;
        if (this.callback != null) {
            this.callback.run();
        }
    }

    public void createArchive(String path, String archiveName, Manifest manifest) {
    }

    public void saveDirEntry(String path, String archiveName, String entryName) {
    }

    public void copyEntry(String source, String path, String archiveName, String entry) {
    }

    public void saveClassEntry(String path, String archiveName, String qualifiedName, String entryName, String content) {
        ClassPath classPath = new ClassPath(qualifiedName.replace("/", "."));
        this.result.put(classPath, new ParsedDocument(content));
        ++this.classCount;
        if (this.callback != null) {
            this.callback.run();
        }
    }

    public void closeArchive(String path, String archiveName) {
    }

    public void writeTo(Path base) throws IOException {
        for (Map.Entry<ClassPath, ParsedDocument> entry : this.result.entrySet()) {
            ClassPath classPath = entry.getKey();
            ParsedDocument s = entry.getValue();
            s.getParamTransformations();
            Path full = classPath.makePath(base);
            BufferedWriter out = Files.newBufferedWriter(full.resolve(classPath.getName() + ".java"), new OpenOption[0]);
            try {
                String[] lines = s.getCode().split("\\n");
                out.write(Arrays.stream(lines).filter(l -> !l.strip().startsWith("// $VF: renamed")).collect(Collectors.joining("\n")));
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
    }

    public Set<Class<?>> getClasses() {
        HashSet classes = new HashSet();
        for (Map.Entry<ClassPath, ParsedDocument> entry : this.result.entrySet()) {
            ClassPath classPath = entry.getKey();
            ParsedDocument parsedDocument = entry.getValue();
            if (parsedDocument.isMixinClass()) continue;
            try {
                classes.add(classPath.forName());
            }
            catch (Throwable throwable) {}
        }
        return classes;
    }

    public ProbeFileSaver callback(Runnable callback) {
        this.callback = callback;
        return this;
    }
}

