/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.decompiler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.main.extern.IContextSource;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;

public class ProbeClassSource
implements IContextSource {
    private final Map<String, Class<?>> classes = new HashMap();

    public ProbeClassSource(Collection<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            this.classes.put(clazz.getName().replace(".", "/"), clazz);
        }
    }

    public String getName() {
        return ProbeClassSource.class.getName();
    }

    public IContextSource.Entries getEntries() {
        List<IContextSource.Entry> entries = this.classes.keySet().stream().map(IContextSource.Entry::atBase).toList();
        return new IContextSource.Entries(entries, List.of(), List.of(), List.of());
    }

    public InputStream getInputStream(String resource) throws IOException {
        Class<?> clazz = this.classes.get(resource.substring(0, resource.length() - ".class".length()));
        return clazz.getClassLoader().getResourceAsStream(resource);
    }

    public IContextSource.IOutputSink createOutputSink(final IResultSaver saver) {
        return new IContextSource.IOutputSink(){

            public void begin() {
            }

            public void acceptClass(String qualifiedName, String fileName, String content, int[] mapping) {
                saver.saveClassEntry("probejs", "probejs", qualifiedName, fileName, content, mapping);
            }

            public void acceptDirectory(String directory) {
            }

            public void acceptOther(String path) {
            }

            public void close() throws IOException {
            }
        };
    }
}

