/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.docs.events;

import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.recipe.viewer.AddEntriesKubeEvent;
import dev.latvian.mods.kubejs.recipe.viewer.AddInformationKubeEvent;
import dev.latvian.mods.kubejs.recipe.viewer.GroupEntriesKubeEvent;
import dev.latvian.mods.kubejs.recipe.viewer.RecipeViewerEntryType;
import dev.latvian.mods.kubejs.recipe.viewer.RecipeViewerEvents;
import dev.latvian.mods.kubejs.recipe.viewer.RegisterSubtypesKubeEvent;
import dev.latvian.mods.kubejs.recipe.viewer.RemoveEntriesKubeEvent;
import dev.latvian.mods.kubejs.recipe.viewer.RemoveRecipesKubeEvent;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import moe.wolfgirl.probejs.lang.java.clazz.ClassPath;
import moe.wolfgirl.probejs.lang.transpiler.TypeConverter;
import moe.wolfgirl.probejs.lang.typescript.ScriptDump;
import moe.wolfgirl.probejs.lang.typescript.TypeScriptFile;
import moe.wolfgirl.probejs.lang.typescript.code.member.ClassDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.MethodDecl;
import moe.wolfgirl.probejs.lang.typescript.code.ts.MethodDeclaration;
import moe.wolfgirl.probejs.lang.typescript.code.ts.Statements;
import moe.wolfgirl.probejs.lang.typescript.code.ts.Wrapped;
import moe.wolfgirl.probejs.lang.typescript.code.type.BaseType;
import moe.wolfgirl.probejs.lang.typescript.code.type.Types;
import moe.wolfgirl.probejs.plugin.ProbeJSPlugin;

public class ViewerEvents
extends ProbeJSPlugin {
    @Override
    public void addGlobals(ScriptDump scriptDump) {
        Wrapped.Namespace events = new Wrapped.Namespace("RecipeViewerEvents");
        TypeConverter typeConverter = scriptDump.transpiler.typeConverter;
        for (Map.Entry entry : RecipeViewerEvents.GROUP.getHandlers().entrySet()) {
            String key = (String)entry.getKey();
            EventHandler handler = (EventHandler)entry.getValue();
            if (handler.target != RecipeViewerEvents.TARGET || !handler.scriptTypePredicate.test(scriptDump.scriptType)) continue;
            for (RecipeViewerEntryType recipeViewerEntryType : (List)RecipeViewerEntryType.ALL_TYPES.get()) {
                events.addCode(ViewerEvents.makeEvent(key, recipeViewerEntryType.id, (Class)handler.eventType.get(), Types.ignoreContext(typeConverter.convertType(recipeViewerEntryType.entryType.type()), BaseType.FormatType.INPUT), Types.ignoreContext(typeConverter.convertType(recipeViewerEntryType.predicateType.type()), BaseType.FormatType.INPUT)));
            }
        }
        scriptDump.addGlobal("recipe_viewer_events", events);
    }

    private static MethodDeclaration makeEvent(String event, String identifier, Class<?> eventClass, BaseType entry, BaseType filter) {
        return Statements.method(event).param("extra", Types.literal(identifier)).param("handler", Types.lambda().param("event", Types.parameterized(Types.type(eventClass), entry, filter)).build()).build();
    }

    @Override
    public void modifyClasses(ScriptDump scriptDump, Map<ClassPath, TypeScriptFile> globalClasses) {
        ViewerEvents.applyEdits(globalClasses, AddEntriesKubeEvent.class, decl -> {
            ViewerEvents.addVariables(decl);
            ViewerEvents.replaceType(decl, "add", 0, "E");
        });
        ViewerEvents.applyEdits(globalClasses, RemoveEntriesKubeEvent.class, decl -> {
            ViewerEvents.addVariables(decl);
            ViewerEvents.replaceType(decl, "remove", 0, "F");
        });
        ViewerEvents.applyEdits(globalClasses, GroupEntriesKubeEvent.class, decl -> {
            ViewerEvents.addVariables(decl);
            ViewerEvents.replaceType(decl, "group", 0, "F");
        });
        ViewerEvents.applyEdits(globalClasses, AddInformationKubeEvent.class, decl -> {
            ViewerEvents.addVariables(decl);
            ViewerEvents.replaceType(decl, "add", 0, "F");
        });
        ViewerEvents.applyEdits(globalClasses, RegisterSubtypesKubeEvent.class, decl -> {
            ViewerEvents.addVariables(decl);
            ViewerEvents.replaceType(decl, "useComponents", 0, "F");
            ViewerEvents.replaceType(decl, "register", 0, "F");
        });
        ViewerEvents.applyEdits(globalClasses, RemoveRecipesKubeEvent.class, decl -> ViewerEvents.replaceType(decl, "remove", 0, Types.primitive("Special.RecipeId").asArray()));
    }

    private static void addVariables(ClassDecl decl) {
        decl.variableTypes.add(Types.generic("E"));
        decl.variableTypes.add(Types.generic("F"));
    }

    private static void replaceType(ClassDecl decl, String name, int index, String symbol) {
        for (MethodDecl method : decl.methods) {
            if (!method.name.equals(name)) continue;
            method.params.get((int)index).type = Types.generic(symbol);
        }
    }

    private static void replaceType(ClassDecl decl, String name, int index, BaseType type) {
        for (MethodDecl method : decl.methods) {
            if (!method.name.equals(name)) continue;
            method.params.get((int)index).type = type;
        }
    }

    private static void applyEdits(Map<ClassPath, TypeScriptFile> globalClasses, Class<?> clazz, Consumer<ClassDecl> edits) {
        TypeScriptFile typeScriptFile = globalClasses.get(new ClassPath(clazz));
        if (typeScriptFile == null) {
            return;
        }
        typeScriptFile.findCode(ClassDecl.class).ifPresent(edits);
    }
}

