/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.docs;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import moe.wolfgirl.probejs.ProbeJS;
import moe.wolfgirl.probejs.docs.Attachments;
import moe.wolfgirl.probejs.docs.Bindings;
import moe.wolfgirl.probejs.docs.Events;
import moe.wolfgirl.probejs.docs.ForgeEventDoc;
import moe.wolfgirl.probejs.docs.LoadClass;
import moe.wolfgirl.probejs.docs.ParamFix;
import moe.wolfgirl.probejs.docs.Primitives;
import moe.wolfgirl.probejs.docs.Snippets;
import moe.wolfgirl.probejs.docs.assignments.AdditionalTypes;
import moe.wolfgirl.probejs.docs.assignments.EnumTypes;
import moe.wolfgirl.probejs.docs.assignments.InterfaceTypes;
import moe.wolfgirl.probejs.docs.assignments.JavaPrimitives;
import moe.wolfgirl.probejs.docs.assignments.RecipeTypes;
import moe.wolfgirl.probejs.docs.assignments.RecordTypes;
import moe.wolfgirl.probejs.docs.assignments.RegistryTypes;
import moe.wolfgirl.probejs.docs.assignments.SpecialTypes;
import moe.wolfgirl.probejs.docs.assignments.WorldTypes;
import moe.wolfgirl.probejs.docs.events.RecipeEvents;
import moe.wolfgirl.probejs.docs.events.RegistryEvents;
import moe.wolfgirl.probejs.docs.events.TagEvents;
import moe.wolfgirl.probejs.docs.events.ViewerEvents;
import moe.wolfgirl.probejs.lang.java.clazz.ClassPath;
import moe.wolfgirl.probejs.lang.schema.SchemaDump;
import moe.wolfgirl.probejs.lang.snippet.SnippetDump;
import moe.wolfgirl.probejs.lang.transpiler.Transpiler;
import moe.wolfgirl.probejs.lang.transpiler.TypeConverter;
import moe.wolfgirl.probejs.lang.typescript.ScriptDump;
import moe.wolfgirl.probejs.lang.typescript.TypeScriptFile;
import moe.wolfgirl.probejs.plugin.ProbeJSPlugin;
import moe.wolfgirl.probejs.utils.GameUtils;

public class ProbeBuiltinDocs
extends ProbeJSPlugin {
    public static final ProbeBuiltinDocs INSTANCE = new ProbeBuiltinDocs();
    public static final List<Supplier<ProbeJSPlugin>> BUILTIN_DOCS = new ArrayList<Supplier>(List.of(RegistryTypes::new, SpecialTypes::new, Primitives::new, JavaPrimitives::new, RecipeTypes::new, WorldTypes::new, EnumTypes::new, InterfaceTypes::new, RecordTypes::new, Bindings::new, Events::new, TagEvents::new, RecipeEvents::new, RegistryEvents::new, ParamFix::new, Snippets::new, ForgeEventDoc::new, AdditionalTypes::new, ViewerEvents::new, Attachments::new, LoadClass::new));

    private static void forEach(Consumer<ProbeJSPlugin> consumer) {
        for (Supplier<ProbeJSPlugin> builtinDoc : BUILTIN_DOCS) {
            try {
                consumer.accept(builtinDoc.get());
            }
            catch (Throwable t) {
                ProbeJS.LOGGER.error("Error when applying builtin doc: %s".formatted(builtinDoc.get().getClass()));
                GameUtils.logException(t);
                ProbeJS.LOGGER.error("If you found severe problem in generated docs (e.g. largely missing types), please report to ProbeJS's github!");
            }
        }
    }

    @Override
    public void addGlobals(ScriptDump scriptDump) {
        ProbeBuiltinDocs.forEach(builtinDoc -> builtinDoc.addGlobals(scriptDump));
    }

    @Override
    public void modifyClasses(ScriptDump scriptDump, Map<ClassPath, TypeScriptFile> globalClasses) {
        ProbeBuiltinDocs.forEach(builtinDoc -> builtinDoc.modifyClasses(scriptDump, globalClasses));
    }

    @Override
    public void assignType(ScriptDump scriptDump) {
        ProbeBuiltinDocs.forEach(builtinDoc -> builtinDoc.assignType(scriptDump));
    }

    @Override
    public void addPredefinedTypes(TypeConverter converter) {
        ProbeBuiltinDocs.forEach(builtinDoc -> builtinDoc.addPredefinedTypes(converter));
    }

    @Override
    public void denyTypes(Transpiler transpiler) {
        ProbeBuiltinDocs.forEach(builtinDoc -> builtinDoc.denyTypes(transpiler));
    }

    @Override
    public Set<Class<?>> provideJavaClass(ScriptDump scriptDump) {
        HashSet allClasses = new HashSet();
        ProbeBuiltinDocs.forEach(builtinDoc -> allClasses.addAll(builtinDoc.provideJavaClass(scriptDump)));
        return allClasses;
    }

    @Override
    public void addVSCodeSnippets(SnippetDump dump) {
        ProbeBuiltinDocs.forEach(builtinDoc -> builtinDoc.addVSCodeSnippets(dump));
    }

    @Override
    public void addJsonSchema(SchemaDump dump) {
        ProbeBuiltinDocs.forEach(builtinDoc -> builtinDoc.addJsonSchema(dump));
    }

    @Override
    public Set<Class<?>> filterScannedClasses(Set<Class<?>> clazz) {
        HashSet allowed = new HashSet();
        ProbeBuiltinDocs.forEach(builtinDoc -> allowed.addAll(builtinDoc.filterScannedClasses(clazz)));
        return allowed;
    }

    @Override
    public Set<Pair<String, String>> disableEventDumps(ScriptDump dump) {
        HashSet<Pair<String, String>> disabled = new HashSet<Pair<String, String>>();
        ProbeBuiltinDocs.forEach(builtinDoc -> disabled.addAll(builtinDoc.disableEventDumps(dump)));
        return disabled;
    }
}

