/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.docs;

import com.google.common.collect.ArrayListMultimap;
import com.mojang.datafixers.util.Pair;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventGroups;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import moe.wolfgirl.probejs.lang.transpiler.TypeConverter;
import moe.wolfgirl.probejs.lang.transpiler.transformation.InjectSpecialType;
import moe.wolfgirl.probejs.lang.typescript.ScriptDump;
import moe.wolfgirl.probejs.lang.typescript.code.Code;
import moe.wolfgirl.probejs.lang.typescript.code.ts.MethodDeclaration;
import moe.wolfgirl.probejs.lang.typescript.code.ts.Statements;
import moe.wolfgirl.probejs.lang.typescript.code.ts.Wrapped;
import moe.wolfgirl.probejs.lang.typescript.code.type.BaseType;
import moe.wolfgirl.probejs.lang.typescript.code.type.TSClassType;
import moe.wolfgirl.probejs.lang.typescript.code.type.TSParamType;
import moe.wolfgirl.probejs.lang.typescript.code.type.Types;
import moe.wolfgirl.probejs.lang.typescript.code.type.js.JSLambdaType;
import moe.wolfgirl.probejs.plugin.ProbeJSPlugin;

public class Events
extends ProbeJSPlugin {
    @Override
    public void addGlobals(ScriptDump scriptDump) {
        Object group;
        ArrayListMultimap availableHandlers = ArrayListMultimap.create();
        Set<Pair<String, String>> disabled = Events.getDisabledEvents(scriptDump);
        TypeConverter converter = scriptDump.transpiler.typeConverter;
        for (Map.Entry entry : ((EventGroups)EventGroups.ALL.get()).map().entrySet()) {
            String groupName = (String)entry.getKey();
            group = (EventGroup)entry.getValue();
            for (EventHandler handler : group.getHandlers().values()) {
                if (!handler.scriptTypePredicate.test(scriptDump.scriptType) || disabled.contains(Pair.of((Object)groupName, (Object)handler.name))) continue;
                availableHandlers.put((Object)groupName, (Object)handler);
            }
        }
        ArrayList<Wrapped.Namespace> codes = new ArrayList<Wrapped.Namespace>();
        for (Map.Entry entry : availableHandlers.asMap().entrySet()) {
            group = (String)entry.getKey();
            Collection handlers = (Collection)entry.getValue();
            Wrapped.Namespace groupNamespace = new Wrapped.Namespace((String)group);
            for (EventHandler handler : handlers) {
                if (handler.target != null) {
                    groupNamespace.addCode(Events.formatEvent(converter, handler, true));
                }
                if (handler.targetRequired) continue;
                groupNamespace.addCode(Events.formatEvent(converter, handler, false));
            }
            codes.add(groupNamespace);
        }
        scriptDump.addGlobal("events", (Code[])codes.toArray(Code[]::new));
    }

    @Override
    public Set<Class<?>> provideJavaClass(ScriptDump scriptDump) {
        HashSet classes = new HashSet();
        for (EventGroup group : ((EventGroups)EventGroups.ALL.get()).map().values()) {
            for (EventHandler handler : group.getHandlers().values()) {
                if (!handler.scriptTypePredicate.test(scriptDump.scriptType)) continue;
                classes.add((Class)handler.eventType.get());
            }
        }
        return classes;
    }

    private static MethodDeclaration formatEvent(TypeConverter converter, EventHandler handler, boolean useExtra) {
        MethodDeclaration.Builder builder = Statements.method(handler.name);
        if (useExtra) {
            BaseType extraType = converter.convertType(handler.target.describeType);
            if (extraType instanceof TSParamType) {
                Info[] infoArray;
                TSParamType paramType = (TSParamType)extraType;
                if (paramType.params.size() == 1 && (infoArray = paramType.baseType) instanceof TSClassType) {
                    TSClassType classType = (TSClassType)infoArray;
                    if (InjectSpecialType.NO_WRAPPING.contains(classType.classPath)) {
                        paramType.params.set(0, Types.ignoreContext(paramType.params.getFirst(), BaseType.FormatType.RETURN));
                    }
                }
            }
            builder.param("extra", extraType);
        }
        Class eventClass = (Class)handler.eventType.get();
        JSLambdaType callback = Types.lambda().param("event", Types.typeMaybeGeneric(eventClass)).build();
        builder.param("handler", callback);
        MethodDeclaration methodDeclaration = builder.build();
        for (Info info : (Info[])eventClass.getAnnotationsByType(Info.class)) {
            methodDeclaration.addComment(info.value());
        }
        return methodDeclaration;
    }

    private static Set<Pair<String, String>> getDisabledEvents(ScriptDump dump) {
        HashSet<Pair<String, String>> events = new HashSet<Pair<String, String>>();
        ProbeJSPlugin.forEachPlugin(plugin -> events.addAll(plugin.disableEventDumps(dump)));
        return events;
    }
}

