/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import moe.wolfgirl.probejs.ProbeConfig;
import moe.wolfgirl.probejs.ProbeJS;
import moe.wolfgirl.probejs.ProbePaths;
import moe.wolfgirl.probejs.features.schema.SchemaDownloader;
import moe.wolfgirl.probejs.lang.decompiler.ProbeDecompiler;
import moe.wolfgirl.probejs.lang.java.ClassRegistry;
import moe.wolfgirl.probejs.lang.schema.SchemaDump;
import moe.wolfgirl.probejs.lang.snippet.SnippetDump;
import moe.wolfgirl.probejs.lang.typescript.ScriptDump;
import moe.wolfgirl.probejs.plugin.ProbeJSPlugin;
import moe.wolfgirl.probejs.utils.GameUtils;
import moe.wolfgirl.probejs.utils.ProbeFileUtils;
import net.minecraft.network.chat.Component;

public class ProbeDump {
    public static final Path SNIPPET_PATH = ProbePaths.WORKSPACE_SETTINGS.resolve("probe.code-snippets");
    public static final Path CLASS_CACHE = ProbePaths.PROBE.resolve("classes.txt");
    final SchemaDump schemaDump = new SchemaDump();
    final SnippetDump snippetDump = new SnippetDump();
    final Collection<ScriptDump> scriptDumps = new ArrayList<ScriptDump>();
    final ProbeDecompiler decompiler = new ProbeDecompiler();
    private Consumer<Component> progressReport;

    public void addScript(ScriptDump dump) {
        if (dump != null) {
            this.scriptDumps.add(dump);
        }
    }

    public void defaultScripts() {
        this.addScript(ScriptDump.CLIENT_DUMP.get());
        this.addScript(ScriptDump.SERVER_DUMP.get());
        this.addScript(ScriptDump.STARTUP_DUMP.get());
    }

    private void onModChange() throws IOException {
        this.decompiler.fromMods();
        if (ProbeConfig.INSTANCE.enableDecompiler.get().booleanValue()) {
            this.report((Component)Component.translatable((String)"probejs.dump.decompiling").kjs$gold());
            this.decompiler.resultSaver.callback(() -> {
                if (this.decompiler.resultSaver.classCount % 3000 == 0) {
                    this.report((Component)Component.translatable((String)"probejs.dump.decompiled_x_class", (Object[])new Object[]{this.decompiler.resultSaver.classCount}));
                }
            });
            this.decompiler.decompileContext();
            this.decompiler.resultSaver.writeTo(ProbePaths.DECOMPILED);
        }
        if (ProbeConfig.INSTANCE.classScanning.get().booleanValue()) {
            ClassRegistry.REGISTRY.fromClasses(this.decompiler.scanner.getScannedClasses(), 0);
        } else {
            HashSet<Class<?>> retained = new HashSet();
            ProbeJSPlugin.forEachPlugin(plugin -> retained.addAll(plugin.filterScannedClasses(this.decompiler.scanner.getScannedClasses())));
            ClassRegistry.REGISTRY.fromClasses(retained, 0);
        }
        this.report((Component)Component.translatable((String)"probejs.dump.cleaning"));
        for (ScriptDump scriptDump : this.scriptDumps) {
            scriptDump.removeClasses();
            this.report((Component)Component.translatable((String)"probejs.removed_script", (Object[])new Object[]{scriptDump.manager.scriptType.toString()}));
        }
        SchemaDownloader downloader = new SchemaDownloader();
        try (ZipInputStream zipStream = downloader.openSchemaStream();){
            downloader.processFile(zipStream);
        }
        catch (Throwable err) {
            ProbeJS.LOGGER.error(err.getMessage());
        }
    }

    private void onRegistryChange() throws IOException {
    }

    private void report(Component component) {
        if (this.progressReport == null) {
            return;
        }
        this.progressReport.accept(component);
    }

    public void trigger(Consumer<Component> p) throws IOException {
        this.progressReport = p;
        this.report((Component)Component.translatable((String)"probejs.dump.start").kjs$green());
        this.snippetDump.fromDocs();
        this.snippetDump.writeTo(SNIPPET_PATH);
        this.schemaDump.fromDocs();
        this.schemaDump.writeTo(ProbePaths.WORKSPACE_SETTINGS);
        this.writeVSCodeConfig();
        this.appendGitIgnore();
        this.report((Component)Component.translatable((String)"probejs.dump.snippets_generated"));
        if (GameUtils.modHash() != ProbeConfig.INSTANCE.modHash.get()) {
            this.report((Component)Component.translatable((String)"probejs.dump.mod_changed").kjs$aqua());
            this.onModChange();
            ProbeConfig.INSTANCE.modHash.set(GameUtils.modHash());
        }
        if (GameUtils.registryHash() != ProbeConfig.INSTANCE.registryHash.get()) {
            this.onRegistryChange();
            ProbeConfig.INSTANCE.registryHash.set(GameUtils.registryHash());
        }
        ClassRegistry.REGISTRY.loadFrom(CLASS_CACHE);
        for (ScriptDump scriptDump : this.scriptDumps) {
            ClassRegistry.REGISTRY.fromClasses(scriptDump.retrieveClasses(), 0);
        }
        ClassRegistry.REGISTRY.discoverClasses();
        ClassRegistry.REGISTRY.writeTo(CLASS_CACHE);
        this.report((Component)Component.translatable((String)"probejs.dump.class_discovered", (Object[])new Object[]{ClassRegistry.REGISTRY.getFoundClasses().size()}));
        ArrayList<Thread> dumpThreads = new ArrayList<Thread>();
        for (ScriptDump scriptDump : this.scriptDumps) {
            Thread t = new Thread(() -> {
                scriptDump.acceptClasses(ClassRegistry.REGISTRY.getFoundClasses());
                try {
                    scriptDump.dump();
                    this.report((Component)Component.translatable((String)"probejs.dump.dump_finished", (Object[])new Object[]{scriptDump.manager.scriptType.toString()}).kjs$green());
                }
                catch (Throwable e) {
                    this.report((Component)Component.translatable((String)"probejs.dump.dump_error", (Object[])new Object[]{scriptDump.manager.scriptType.toString()}).kjs$red());
                    throw new RuntimeException(e);
                }
            }, "ProbeDumpingThread-" + scriptDump.scriptType.name);
            t.start();
            dumpThreads.add(t);
        }
        Thread thread = new Thread(() -> {
            try {
                while (true) {
                    Thread.sleep(3000L);
                    if (dumpThreads.stream().noneMatch(Thread::isAlive)) {
                        return;
                    }
                    String dumpProgress = this.scriptDumps.stream().filter(sd -> sd.total != 0).map(sd -> "%s/%s".formatted(sd.dumped, sd.total)).collect(Collectors.joining(", "));
                    this.report((Component)Component.translatable((String)"probejs.dump.report_progress").append((Component)Component.literal((String)dumpProgress).kjs$blue()));
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }, "ProbeDumpingThread-report");
        thread.start();
    }

    private void writeVSCodeConfig() throws IOException {
        ProbeFileUtils.writeMergedConfig(ProbePaths.VSCODE_JSON, "{\n    \"typescript.tsserver.maxTsServerMemory\": 4096,\n    \"json.schemas\": [\n        {\n            \"fileMatch\": [\n                \"/recipe_schemas/*.json\"\n            ],\n            \"url\": \"./.vscode/recipe.json\"\n        }\n    ]\n}\n");
    }

    private void appendGitIgnore() throws IOException {
        boolean shouldAppend;
        try (BufferedReader reader = Files.newBufferedReader(ProbePaths.GIT_IGNORE);){
            shouldAppend = reader.lines().noneMatch(s -> s.equals(".probe"));
        }
        catch (IOException ignore) {
            shouldAppend = true;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(ProbePaths.GIT_IGNORE, StandardOpenOption.APPEND, StandardOpenOption.CREATE);){
            if (shouldAppend) {
                writer.write("\n.probe\n");
            }
        }
    }
}

