/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import moe.wolfgirl.probejs.ProbeJS;
import moe.wolfgirl.probejs.ProbePaths;
import moe.wolfgirl.probejs.utils.JsonUtils;

public class ProbeConfig {
    public static ProbeConfig INSTANCE = new ProbeConfig();
    public ConfigEntry<Boolean> enabled = new ConfigEntry<Boolean>("enabled", true);
    public ConfigEntry<Boolean> enableDecompiler = new ConfigEntry<Boolean>("enableDecompiler", false);
    public ConfigEntry<Integer> recursionDepth = new ConfigEntry<Integer>("recursionDepth", 5);
    public ConfigEntry<Boolean> classScanning = new ConfigEntry<Boolean>("classScanning", false);
    public ConfigEntry<Long> modHash = new ConfigEntry<Long>("modHash", -1L);
    public ConfigEntry<Long> registryHash = new ConfigEntry<Long>("registryHash", -1L);
    public ConfigEntry<Boolean> isolatedScopes = new ConfigEntry<Boolean>("isolatedScope", false);
    public ConfigEntry<Boolean> complete = new ConfigEntry<Boolean>("complete", true);

    private static void writeConfigEntry(ConfigEntry<?> configEntry) throws IOException {
        String name = configEntry.name;
        Object value = configEntry.value;
        JsonObject current = new JsonObject();
        if (Files.exists(ProbePaths.SETTINGS_JSON, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(ProbePaths.SETTINGS_JSON);){
                String content = reader.lines().collect(Collectors.joining("\n"));
                current = (JsonObject)ProbeJS.GSON.fromJson(JsonUtils.stripSussyJson5Stuffs(content), JsonObject.class);
            }
        }
        current.add("%s.%s".formatted(configEntry.namespace, name), JsonUtils.parseObject(value));
        try (BufferedWriter writer = Files.newBufferedWriter(ProbePaths.SETTINGS_JSON, new OpenOption[0]);){
            JsonWriter jsonWriter = ProbeJS.GSON_WRITER.newJsonWriter((Writer)writer);
            jsonWriter.setIndent("    ");
            ProbeJS.GSON_WRITER.toJson((Object)current, JsonObject.class, jsonWriter);
        }
    }

    private static Object getConfigEntry(ConfigEntry<?> configEntry) throws IOException {
        Object object;
        JsonObject current = new JsonObject();
        if (Files.exists(ProbePaths.SETTINGS_JSON, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(ProbePaths.SETTINGS_JSON);){
                String content = reader.lines().collect(Collectors.joining("\n"));
                current = (JsonObject)ProbeJS.GSON.fromJson(JsonUtils.stripSussyJson5Stuffs(content), JsonObject.class);
            }
        }
        if ((object = JsonUtils.deserializeObject((JsonElement)current)) instanceof Map) {
            Map map = (Map)object;
            return map.get("%s.%s".formatted(configEntry.namespace, configEntry.name));
        }
        return null;
    }

    public static class ConfigEntry<T> {
        public final String name;
        public final T defaultValue;
        private T value;
        private final String namespace;
        private boolean changed = true;

        ConfigEntry(String name, @Nonnull T defaultValue) {
            this(name, defaultValue, "probejs");
        }

        ConfigEntry(String name, @Nonnull T defaultValue, String namespace) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.namespace = namespace;
        }

        public void set(T value) {
            if (value == null) {
                value = this.defaultValue;
            }
            if (Objects.equals(this.value, value)) {
                return;
            }
            this.value = value;
            try {
                ProbeConfig.writeConfigEntry(this);
                this.changed = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public T get() {
            try {
                if (this.changed) {
                    this.fromSetting();
                }
                this.changed = false;
            }
            catch (IOException e) {
                return this.defaultValue;
            }
            return this.value == null ? this.defaultValue : this.value;
        }

        private void fromSetting() throws IOException {
            Class<?> typeClass = this.defaultValue.getClass();
            Object configValue = ProbeConfig.getConfigEntry(this);
            if (configValue == null) {
                this.value = null;
            } else if (configValue instanceof Number) {
                Number number = (Number)configValue;
                if (typeClass == Integer.class) {
                    configValue = number.intValue();
                }
                if (typeClass == Float.class) {
                    configValue = Float.valueOf(number.floatValue());
                }
                if (typeClass == Long.class) {
                    configValue = number.longValue();
                }
                if (typeClass == Byte.class) {
                    configValue = number.byteValue();
                }
                if (typeClass == Double.class) {
                    configValue = number.doubleValue();
                }
                if (typeClass == Short.class) {
                    configValue = number.shortValue();
                }
                this.value = configValue;
            } else if (typeClass.isInstance(configValue)) {
                this.value = configValue;
            }
        }
    }
}

