/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.client;

import appeng.client.gui.style.ScreenStyle;
import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.client.abstraction.AbstractRequesterScreen;
import com.almostreliable.merequester.client.abstraction.RequesterReference;
import com.almostreliable.merequester.core.Config;
import com.almostreliable.merequester.requester.RequesterMenu;
import java.util.Collections;
import java.util.Set;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.Nullable;

public class RequesterScreen
extends AbstractRequesterScreen<RequesterMenu> {
    private static final ResourceLocation TEXTURE = Utils.getRL(String.format("textures/gui/%s.png", "requester"));
    private static final Rect2i FOOTER_BBOX = new Rect2i(0, 114, 195, 101);
    private static final int MAX_ROW_COUNT = 10;
    @Nullable
    private RequesterReference requesterReference;

    public RequesterScreen(RequesterMenu menu, Inventory playerInventory, Component name, ScreenStyle style) {
        super(menu, playerInventory, name, style, TEXTURE);
    }

    @Override
    protected void init() {
        int possibleRows = (this.height - 20 - 99) / 19;
        this.rowAmount = Mth.clamp((int)possibleRows, (int)3, (int)Math.min((Integer)Config.COMMON.requests.get(), 10));
        super.init();
    }

    @Override
    protected void clear() {
    }

    @Override
    protected void refreshList() {
        if (this.requesterReference != null) {
            this.lines.clear();
            this.lines.ensureCapacity((Integer)Config.COMMON.requests.get());
            for (int i = 0; i < this.requesterReference.getRequestManager().size(); ++i) {
                this.lines.add(this.requesterReference.getRequestManager().get(i));
            }
        }
        this.refreshList = false;
        this.resetScrollbar();
    }

    @Override
    protected Set<RequesterReference> getByName(String name) {
        if (this.requesterReference == null || !this.requesterReference.getDisplayName().equals(name)) {
            throw new IllegalStateException("reference is null or name doesn't match");
        }
        return Collections.singleton(this.requesterReference);
    }

    @Override
    protected RequesterReference getById(long requesterId, String name, long sortBy) {
        if (this.requesterReference == null) {
            this.requesterReference = new RequesterReference(requesterId, name, sortBy);
            this.refreshList = true;
        }
        return this.requesterReference;
    }

    @Override
    protected Rect2i getFooterBounds() {
        return FOOTER_BBOX;
    }
}

