/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.brickfurnace.init;

import de.cech12.brickfurnace.Constants;
import de.cech12.brickfurnace.block.BrickBlastFurnaceBlock;
import de.cech12.brickfurnace.block.BrickFurnaceBlock;
import de.cech12.brickfurnace.block.BrickSmokerBlock;
import java.util.function.ToIntFunction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.createBlocks((String)"brickfurnace");

    private static ToIntFunction<BlockState> getLightLevelWhenLit(int lightLevel) {
        return blockState -> (Boolean)blockState.getValue((Property)BlockStateProperties.LIT) != false ? lightLevel : 0;
    }

    static {
        Constants.BRICK_FURNACE_BLOCK = BLOCKS.register("brick_furnace", () -> new BrickFurnaceBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).requiresCorrectToolForDrops().strength(2.0f, 6.0f).lightLevel(ModBlocks.getLightLevelWhenLit(13))));
        Constants.BRICK_BLAST_FURNACE_BLOCK = BLOCKS.register("brick_blast_furnace", () -> new BrickBlastFurnaceBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).requiresCorrectToolForDrops().strength(2.0f, 6.0f).lightLevel(ModBlocks.getLightLevelWhenLit(13))));
        Constants.BRICK_SMOKER_BLOCK = BLOCKS.register("brick_smoker", () -> new BrickSmokerBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).requiresCorrectToolForDrops().strength(2.0f, 6.0f).lightLevel(ModBlocks.getLightLevelWhenLit(13))));
    }
}

