/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.buffer;

import codechicken.lib.render.buffer.DelegateRenderType;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;

public class VBORenderType
extends DelegateRenderType
implements AutoCloseable {
    private final BiConsumer<VertexFormat, BufferBuilder> factory;
    private final VertexBuffer vertexBuffer = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
    private final ByteBufferBuilder builder;
    private boolean dirty = true;

    public VBORenderType(RenderType parent, BiConsumer<VertexFormat, BufferBuilder> factory) {
        super(parent, parent.format());
        this.factory = factory;
        this.builder = new ByteBufferBuilder(this.bufferSize());
    }

    public void setDirty() {
        this.dirty = true;
    }

    public WithCallbacks withCallback(Runnable action) {
        return new WithCallbacks().withAction(action);
    }

    public WithCallbacks withState(RenderStateShard shard) {
        return new WithCallbacks().withState(shard);
    }

    public void draw(MultiBufferSource buffers) {
        VBORenderType.draw(buffers, this);
    }

    private static void draw(MultiBufferSource buffers, RenderType type) {
        VertexConsumer cons = buffers.getBuffer(type);
        for (int i = 0; i < type.mode().primitiveLength; ++i) {
            cons.addVertex(0.0f, 0.0f, 0.0f, 0, 0.0f, 0.0f, 0, 0, 0.0f, 0.0f, 0.0f);
        }
    }

    private void render() {
        this.rebuild();
        this.vertexBuffer.bind();
        this.vertexBuffer.drawWithShader(RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix(), Objects.requireNonNull(RenderSystem.getShader()));
    }

    private void rebuild() {
        if (!this.dirty) {
            return;
        }
        this.builder.discard();
        BufferBuilder buffer = new BufferBuilder(this.builder, this.mode(), this.format());
        this.factory.accept(this.format(), buffer);
        this.vertexBuffer.bind();
        this.vertexBuffer.upload(buffer.build());
        this.builder.clear();
        this.dirty = false;
    }

    @Override
    public void draw(MeshData meshData) {
        try (MeshData meshData2 = meshData;){
            this.setupRenderState();
            this.render();
            this.clearRenderState();
        }
    }

    @Override
    public void close() throws Exception {
        this.vertexBuffer.close();
    }

    public class WithCallbacks
    extends DelegateRenderType {
        private final List<RenderStateShard> shards;

        public WithCallbacks() {
            super(VBORenderType.this);
            this.shards = new LinkedList<RenderStateShard>();
        }

        public WithCallbacks withAction(final Runnable action) {
            return this.withState(new RenderStateShard(this, "none", SneakyUtils.none(), SneakyUtils.none()){

                public void setupRenderState() {
                    action.run();
                }
            });
        }

        public WithCallbacks withState(RenderStateShard shard) {
            this.shards.add(shard);
            return this;
        }

        @Override
        public void setupRenderState() {
            super.setupRenderState();
            for (RenderStateShard state : this.shards) {
                state.setupRenderState();
            }
        }

        @Override
        public void draw(MeshData meshData) {
            try (MeshData meshData2 = meshData;){
                this.setupRenderState();
                VBORenderType.this.render();
                this.clearRenderState();
            }
        }

        @Override
        public void clearRenderState() {
            for (RenderStateShard state : this.shards) {
                state.clearRenderState();
            }
            super.clearRenderState();
        }

        public void draw(MultiBufferSource buffers) {
            VBORenderType.draw(buffers, this);
        }
    }
}

