/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.pipeline;

import codechicken.lib.model.CachedFormat;
import codechicken.lib.model.IVertexConsumer;
import codechicken.lib.model.Quad;
import codechicken.lib.model.pipeline.IPipelineConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public abstract class QuadTransformer
implements IVertexConsumer,
IPipelineConsumer {
    protected final Quad quad;
    @Nullable
    protected CachedFormat format;
    @Nullable
    protected IVertexConsumer consumer;
    private static final double EPSILON = 1.0E-5;

    protected QuadTransformer() {
        this.quad = new Quad();
    }

    public QuadTransformer(IVertexConsumer consumer) {
        this(consumer.getVertexFormat(), consumer);
    }

    public QuadTransformer(VertexFormat format, IVertexConsumer consumer) {
        this(CachedFormat.lookup(format), consumer);
    }

    public QuadTransformer(CachedFormat format, IVertexConsumer consumer) {
        this.format = format;
        this.consumer = consumer;
        this.quad = new Quad(format);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void reset(CachedFormat format) {
        this.format = format;
        this.quad.reset(format);
    }

    @Override
    public void setParent(@Nullable IVertexConsumer parent) {
        this.consumer = parent;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void setInputQuad(Quad quad) {
        if (this.consumer instanceof IPipelineConsumer) {
            ((IPipelineConsumer)this.consumer).setInputQuad(quad);
        }
    }

    @Override
    public VertexFormat getVertexFormat() {
        return Objects.requireNonNull(this.format).format;
    }

    @Override
    public void setQuadTint(int tint) {
        this.quad.setQuadTint(tint);
    }

    @Override
    public void setQuadOrientation(Direction orientation) {
        this.quad.setQuadOrientation(orientation);
    }

    @Override
    public void setApplyDiffuseLighting(boolean diffuse) {
        this.quad.setApplyDiffuseLighting(diffuse);
    }

    @Override
    public void setTexture(TextureAtlasSprite texture) {
        this.quad.setTexture(texture);
    }

    @Override
    public void put(int element, float ... data) {
        this.quad.put(element, data);
        if (this.quad.full) {
            this.onFull();
        }
    }

    @Override
    public void put(Quad quad) {
        this.quad.put(quad);
        this.onFull();
    }

    public abstract boolean transform();

    public void onFull() {
        if (this.transform()) {
            this.quad.pipe(Objects.requireNonNull(this.consumer));
        }
    }

    public static boolean epsComp(float a, float b) {
        if (a == b) {
            return true;
        }
        return (double)Math.abs(a - b) < 1.0E-5;
    }
}

