/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import codechicken.lib.inventory.InventoryRange;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.ArrayUtils;
import java.util.Objects;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class InventoryCopy
implements Container {
    public boolean[] accessible;
    public ItemStack[] items;
    public Container inv;

    public InventoryCopy(Container inv) {
        this.items = new ItemStack[inv.getContainerSize()];
        ArrayUtils.fillArray(this.items, ItemStack.EMPTY, Objects::isNull);
        this.accessible = new boolean[inv.getContainerSize()];
        this.inv = inv;
        this.update();
    }

    public void update() {
        for (int i = 0; i < this.items.length; ++i) {
            ItemStack stack = this.inv.getItem(i);
            if (stack.isEmpty()) continue;
            this.items[i] = stack.copy();
        }
    }

    public InventoryCopy open(InventoryRange access) {
        int lslot = access.lastSlot();
        if (lslot > this.accessible.length) {
            boolean[] l_accessible = new boolean[lslot];
            ItemStack[] l_items = new ItemStack[lslot];
            System.arraycopy(this.accessible, 0, l_accessible, 0, this.accessible.length);
            System.arraycopy(this.items, 0, l_items, 0, this.items.length);
            this.accessible = l_accessible;
            this.items = l_items;
        }
        for (int slot : access.slots) {
            this.accessible[slot] = true;
        }
        return this;
    }

    public int getContainerSize() {
        return this.items.length;
    }

    public boolean isEmpty() {
        return ArrayUtils.count(this.items, stack -> !stack.isEmpty()) <= 0;
    }

    public ItemStack getItem(int slot) {
        return this.items[slot];
    }

    public ItemStack removeItem(int slot, int amount) {
        return InventoryUtils.decrStackSize(this, slot, amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return InventoryUtils.removeStackFromSlot(this, slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.items[slot] = stack;
        this.setChanged();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void setChanged() {
    }

    public boolean canPlaceItem(int i, ItemStack itemstack) {
        return this.inv.canPlaceItem(i, itemstack);
    }

    public void clearContent() {
    }
}

