/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.skyblockbuilder.world.presets.SkyblockPreset;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import org.moddingx.libx.codec.MoreCodecs;

public class CoreUtil {
    public static Codec<WorldPreset> augmentWorldPresetCodec(Codec<WorldPreset> codec) {
        Codec skyblockCodecBase = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.retrieveGetter((ResourceKey)Registries.DIMENSION_TYPE), (App)RegistryOps.retrieveGetter((ResourceKey)Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST), (App)RegistryOps.retrieveGetter((ResourceKey)Registries.NOISE_SETTINGS), (App)RegistryOps.retrieveRegistryLookup((ResourceKey)Registries.BIOME).forGetter(SkyblockPreset::getBiomes)).apply((Applicative)instance, SkyblockPreset::new));
        MapCodec skyblockCodecId = Codec.STRING.fieldOf("type").flatXmap(str -> "skyblockbuilder:skyblock".equals(str) ? DataResult.success((Object)Unit.INSTANCE) : DataResult.error(() -> "Wrong type"), unit -> DataResult.success((Object)"skyblockbuilder:skyblock"));
        Codec skyblockCodec = MoreCodecs.extend((Codec)skyblockCodecBase, (MapCodec)skyblockCodecId, preset -> Pair.of((Object)preset, (Object)Unit.INSTANCE), (preset, unit) -> preset);
        return new SkyblockPresetCodec(codec, (Codec<SkyblockPreset>)skyblockCodec);
    }

    private record SkyblockPresetCodec(Codec<WorldPreset> base, Codec<SkyblockPreset> skyblock) implements Codec<WorldPreset>
    {
        public <T> DataResult<T> encode(WorldPreset input, DynamicOps<T> ops, T prefix) {
            if (input instanceof SkyblockPreset) {
                SkyblockPreset skyblockPreset = (SkyblockPreset)input;
                return this.skyblock().encode((Object)skyblockPreset, ops, prefix);
            }
            return this.base().encode((Object)input, ops, prefix);
        }

        public <T> DataResult<Pair<WorldPreset, T>> decode(DynamicOps<T> ops, T input) {
            DataResult skyblockResult = this.skyblock().decode(ops, input);
            if (skyblockResult.result().isPresent()) {
                return skyblockResult;
            }
            return this.base().decode(ops, input);
        }
    }
}

