/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.skyblockbuilder.registration.ModBlocks;
import de.melanx.skyblockbuilder.registration.ModDataComponentTypes;
import de.melanx.skyblockbuilder.registration.ModItems;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.SkyPaths;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public record StructureSaverSettings(String name, boolean saveToConfig, boolean ignoreAir, boolean nbtToSnbt, boolean keepPositions) {
    public static final Codec<StructureSaverSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("name", (Object)"").forGetter(StructureSaverSettings::name), (App)Codec.BOOL.optionalFieldOf("save_to_config", (Object)false).forGetter(StructureSaverSettings::saveToConfig), (App)Codec.BOOL.optionalFieldOf("ignore_air", (Object)false).forGetter(StructureSaverSettings::ignoreAir), (App)Codec.BOOL.optionalFieldOf("nbt_to_snbt", (Object)false).forGetter(StructureSaverSettings::nbtToSnbt), (App)Codec.BOOL.optionalFieldOf("keep_positions", (Object)true).forGetter(StructureSaverSettings::keepPositions)).apply((Applicative)instance, StructureSaverSettings::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, StructureSaverSettings> STREAM_CODEC = StreamCodec.of((buffer, value) -> {
        buffer.writeUtf(value.name);
        buffer.writeBoolean(value.saveToConfig);
        buffer.writeBoolean(value.ignoreAir);
        buffer.writeBoolean(value.nbtToSnbt);
        buffer.writeBoolean(value.keepPositions);
    }, buffer -> new StructureSaverSettings(buffer.readUtf(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean()));
    public static final StructureSaverSettings DEFAULT = new StructureSaverSettings("", false, false, false, true);

    public static enum Type {
        ISLAND((Component)SkyComponents.SCREEN_STRUCTURE_SAVER_TAB_ISLAND, SkyPaths.ISLANDS_DIR, () -> ModBlocks.spawnBlock),
        SPREAD((Component)SkyComponents.SCREEN_STRUCTURE_SAVER_TAB_SPREAD, SkyPaths.SPREADS_DIR, () -> Blocks.AIR),
        NETHER((Component)SkyComponents.SCREEN_STRUCTURE_SAVER_TAB_NETHER, SkyPaths.PORTALS_DIR, () -> Blocks.NETHER_PORTAL);

        private final Component tooltip;
        private final Path outputPath;
        private final Supplier<Block> blockSupplier;
        private ItemStack stack;

        private Type(Component tooltip, Path outputPath, Supplier<Block> blockSupplier) {
            this.tooltip = tooltip;
            this.outputPath = outputPath;
            this.blockSupplier = blockSupplier;
        }

        public ItemStack getStack() {
            if (this.stack == null) {
                this.stack = new ItemStack((ItemLike)ModItems.structureSaver);
                this.stack.set(ModDataComponentTypes.structureSaverType, (Object)this);
            }
            return this.stack;
        }

        public Component getTooltip() {
            return this.tooltip;
        }

        public Path getOutputPath() {
            return this.outputPath;
        }

        public Block getRequiredBlock() {
            return this.blockSupplier.get();
        }
    }
}

