/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.team;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.commands.Suggestions;
import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.config.common.SpawnConfig;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.data.TemplateData;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.events.SkyblockManageTeamEvent;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.WorldUtil;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class EditTeamSpawnsCommand {
    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spawns").then(((LiteralArgumentBuilder)Commands.literal((String)"add").executes(context -> EditTeamSpawnsCommand.addSpawn((CommandSourceStack)context.getSource(), BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition())))).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> EditTeamSpawnsCommand.addSpawn((CommandSourceStack)context.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"pos")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").executes(context -> EditTeamSpawnsCommand.removeSpawn((CommandSourceStack)context.getSource(), BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition())))).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).suggests(Suggestions.SPAWN_POSITIONS).executes(context -> EditTeamSpawnsCommand.removeSpawn((CommandSourceStack)context.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"pos")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"reset").executes(context -> EditTeamSpawnsCommand.resetSpawns((CommandSourceStack)context.getSource(), null))).then(Commands.argument((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.ALL_TEAMS).executes(context -> EditTeamSpawnsCommand.resetSpawns((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"team")))));
    }

    private static int addSpawn(CommandSourceStack source, BlockPos pos) throws CommandSyntaxException {
        ValidationResult validationResult = EditTeamSpawnsCommand.validateTeamSpawnLocation(source);
        if (validationResult == null) {
            return 0;
        }
        ServerPlayer player = validationResult.player();
        Team team = validationResult.team();
        if (team == null) {
            if (!PermissionManager.INSTANCE.mayExecuteOpCommand((Player)player)) {
                source.sendFailure((Component)SkyComponents.ERROR_USER_HAS_NO_TEAM);
                return 0;
            }
            source.sendFailure((Component)SkyComponents.WARNING_EDIT_SPAWN_SPAWNS);
            team = SkyblockSavedData.get(player.level()).getSpawn();
        }
        Pair<SkyblockManageTeamEvent.Result, TemplatesConfig.Spawn> result = SkyblockHooks.onAddSpawn(player, team, pos, player.getDirection());
        switch ((SkyblockManageTeamEvent.Result)((Object)result.getLeft())) {
            case DENY: {
                source.sendFailure((Component)SkyComponents.DENIED_CREATE_SPAWN);
                return 0;
            }
            case DEFAULT: {
                if (!PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.EDIT_SPAWNS)) {
                    source.sendFailure((Component)SkyComponents.DISABLED_MODIFY_SPAWNS);
                    return 0;
                }
                Vec3i templateSize = TemplateData.get((ServerLevel)player.level()).getConfiguredTemplate().getTemplate().getSize();
                BlockPos.MutableBlockPos center = team.getIsland().getCenter().mutable();
                center.offset(templateSize.getX() / 2, templateSize.getY() / 2, templateSize.getZ() / 2);
                if (((TemplatesConfig.Spawn)result.getValue()).pos().closerThan((Vec3i)center, (double)PermissionsConfig.Spawns.range)) break;
                source.sendFailure((Component)SkyComponents.ERROR_POSITION_TOO_FAR_AWAY);
                return 0;
            }
        }
        team.addPossibleSpawn((TemplatesConfig.Spawn)result.getValue());
        source.sendSuccess(() -> ((MutableComponent)SkyComponents.SUCCESS_SPAWN_ADDED.apply((Object)pos.getX(), (Object)pos.getY(), (Object)pos.getZ())).withStyle(ChatFormatting.GOLD), false);
        return 1;
    }

    private static int removeSpawn(CommandSourceStack source, BlockPos pos) throws CommandSyntaxException {
        ValidationResult validationResult = EditTeamSpawnsCommand.validateTeamSpawnLocation(source);
        if (validationResult == null) {
            return 0;
        }
        if (validationResult.team() == null) {
            source.sendFailure((Component)SkyComponents.ERROR_USER_HAS_NO_TEAM);
            return 0;
        }
        switch (SkyblockHooks.onRemoveSpawn(validationResult.player(), validationResult.team(), pos)) {
            case DENY: {
                MutableComponent component = SkyComponents.DENIED_MODIFY_SPAWNS0;
                if (validationResult.team().getPossibleSpawns().size() <= 1) {
                    component.append(" ").append((Component)SkyComponents.DENIED_MODIFY_SPAWNS1);
                }
                source.sendFailure((Component)component);
                return 0;
            }
            case DEFAULT: {
                if (PermissionManager.INSTANCE.hasPermission((Player)validationResult.player(), PermissionManager.Permission.EDIT_SPAWNS)) break;
                source.sendFailure((Component)SkyComponents.DISABLED_MODIFY_SPAWNS);
                return 0;
            }
        }
        if (!validationResult.team().removePossibleSpawn(pos)) {
            MutableComponent component = SkyComponents.ERROR_REMOVE_SPAWN0;
            if (validationResult.team().getPossibleSpawns().size() <= 1) {
                component.append(" ").append((Component)SkyComponents.ERROR_REMOVE_SPAWN1);
            }
            source.sendFailure((Component)component);
            return 0;
        }
        source.sendSuccess(() -> (Component)SkyComponents.SUCCESS_SPAWN_REMOVED.apply((Object)pos.getX(), (Object)pos.getY(), (Object)pos.getZ()), false);
        return 1;
    }

    @Nullable
    private static ValidationResult validateTeamSpawnLocation(CommandSourceStack source) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.getLevel();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        if (level != source.getServer().getLevel(SpawnConfig.spawnDimension)) {
            source.sendFailure((Component)SkyComponents.ERROR_WRONG_POSITION);
            return null;
        }
        ServerPlayer player = source.getPlayerOrException();
        Team team = data.getTeamFromPlayer((Player)player);
        return new ValidationResult(player, team);
    }

    private static int resetSpawns(CommandSourceStack source, String name) throws CommandSyntaxException {
        Team team;
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.getLevel();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        ServerPlayer player = null;
        if (name == null) {
            if (!(source.getEntity() instanceof ServerPlayer)) {
                source.sendFailure((Component)SkyComponents.ERROR_USER_NO_PLAYER);
                return 0;
            }
            player = (ServerPlayer)source.getEntity();
            team = data.getTeamFromPlayer((Player)player);
            if (team == null) {
                source.sendFailure((Component)SkyComponents.ERROR_USER_HAS_NO_TEAM);
                return 0;
            }
        } else {
            team = data.getTeam(name);
            if (team == null) {
                source.sendFailure((Component)SkyComponents.ERROR_TEAM_NOT_EXIST);
                return 0;
            }
        }
        SkyblockManageTeamEvent.Result result = SkyblockHooks.onResetSpawns(player, team);
        switch (result) {
            case DENY: {
                source.sendFailure((Component)SkyComponents.DENIED_RESET_SPAWNS);
                return 0;
            }
            case DEFAULT: {
                if (PermissionManager.INSTANCE.hasPermission(source, PermissionManager.Permission.EDIT_SPAWNS)) break;
                source.sendFailure((Component)SkyComponents.DISABLED_MODIFY_SPAWNS);
                return 0;
            }
        }
        team.setPossibleSpawns(team.getDefaultPossibleSpawns());
        source.sendSuccess(() -> SkyComponents.SUCCESS_RESET_SPAWNS, true);
        return 1;
    }

    private record ValidationResult(ServerPlayer player, Team team) {
    }
}

