/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.operator;

import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.commands.Suggestions;
import de.melanx.skyblockbuilder.config.common.InventoryConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.data.TemplateData;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.template.TemplateLoader;
import de.melanx.skyblockbuilder.util.NameGenerator;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.WorldUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class ManageCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"manage").requires(PermissionManager.INSTANCE::mayExecuteOpCommand)).then(Commands.literal((String)"islandShape").then(Commands.argument((String)"template", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.TEMPLATES).executes(context -> ManageCommand.refreshIsland((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"template")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"teams").then(((LiteralArgumentBuilder)Commands.literal((String)"clear").executes(context -> ManageCommand.deleteEmptyTeams((CommandSourceStack)context.getSource()))).then(Commands.argument((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.ALL_TEAMS).executes(context -> ManageCommand.clearTeam((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"team")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"create").executes(context -> ManageCommand.createTeam((CommandSourceStack)context.getSource(), false))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> ManageCommand.createTeam((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), false))))).then(((LiteralArgumentBuilder)Commands.literal((String)"createAndJoin").executes(context -> ManageCommand.createTeam((CommandSourceStack)context.getSource(), true))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> ManageCommand.createTeam((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), true))))).then(Commands.literal((String)"delete").then(Commands.argument((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.ALL_TEAMS).executes(context -> ManageCommand.deleteTeam((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"team"))))))).then(Commands.literal((String)"addPlayer").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.ALL_TEAMS).executes(context -> ManageCommand.addToTeam((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"team"), EntityArgument.getPlayers((CommandContext)context, (String)"players"))))))).then(Commands.literal((String)"kickPlayer").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> ManageCommand.removeFromTeam((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player")))));
    }

    private static int refreshIsland(CommandSourceStack source, String name) {
        TemplateLoader.setTemplate(TemplateLoader.getConfiguredTemplate(name));
        TemplateData.get(source.getLevel()).refreshTemplate();
        source.sendSuccess(() -> (Component)SkyComponents.SUCCESS_RESET_ISLAND.apply(name), true);
        return 1;
    }

    private static int deleteEmptyTeams(CommandSourceStack source) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.getLevel();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        int i = 0;
        Iterator<Team> itr = data.getTeams().iterator();
        while (itr.hasNext()) {
            Team team = itr.next();
            if (SkyblockHooks.onManageDeleteTeam(source, team) || !team.isEmpty()) continue;
            itr.remove();
            ++i;
        }
        data.setDirty();
        int teamsAmount = i;
        source.sendSuccess(() -> (Component)SkyComponents.SUCCESS_DELETE_MULTIPLE_TEAMS.apply(teamsAmount), true);
        return 1;
    }

    private static int clearTeam(CommandSourceStack source, String teamName) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.getLevel();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        Team team = data.getTeam(teamName);
        if (team == null) {
            source.sendFailure((Component)SkyComponents.ERROR_TEAM_NOT_EXIST);
            return 0;
        }
        if (SkyblockHooks.onManageClearTeam(source, team)) {
            source.sendFailure((Component)SkyComponents.DENIED_CLEAR_TEAM);
            return 0;
        }
        int i = team.getPlayers().size();
        data.removeAllPlayersFromTeam(team);
        RandomUtility.deleteTeamIfEmpty(data, team);
        source.sendSuccess(() -> (Component)SkyComponents.SUCCESS_REMOVE_ALL_PLAYERS_FROM_TEAM.apply(i), true);
        return 1;
    }

    private static int createTeam(CommandSourceStack source, boolean join) throws CommandSyntaxException {
        String team;
        WorldUtil.checkSkyblock(source);
        Random rand = new Random();
        do {
            team = NameGenerator.randomName(rand);
        } while (SkyblockSavedData.get((Level)source.getLevel()).teamExists(team));
        return ManageCommand.createTeam(source, team, join);
    }

    private static int createTeam(CommandSourceStack source, String name, boolean join) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.getLevel();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        Pair<Boolean, String> result = SkyblockHooks.onManageCreateTeam(source, name, join);
        if (((Boolean)result.getLeft()).booleanValue()) {
            source.sendFailure((Component)SkyComponents.DENIED_CREATE_TEAM);
            return 0;
        }
        Team team = data.createTeam((String)result.getRight());
        if (team == null) {
            source.sendFailure((Component)SkyComponents.ERROR_TEAM_ALREADY_EXIST.apply((String)result.getRight()));
            return 0;
        }
        if (join) {
            try {
                ServerPlayer player = source.getPlayerOrException();
                if (data.getTeamFromPlayer((Player)player) != null) {
                    source.sendFailure((Component)SkyComponents.ERROR_USER_HAS_TEAM);
                    return 0;
                }
                data.addPlayerToTeam(team, (Player)player);
                WorldUtil.teleportToIsland(player, team);
            }
            catch (CommandSyntaxException e) {
                source.sendFailure((Component)SkyComponents.ERROR_USER_NO_PLAYER);
                return 1;
            }
        }
        source.sendSuccess(() -> (Component)SkyComponents.SUCCESS_CREATE_TEAM.apply((String)result.getRight()), true);
        return 1;
    }

    private static int deleteTeam(CommandSourceStack source, String team) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.getLevel();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        if (!data.teamExists(team)) {
            source.sendFailure((Component)SkyComponents.ERROR_TEAM_NOT_EXIST);
            return 0;
        }
        if (SkyblockHooks.onManageDeleteTeam(source, data.getTeam(team))) {
            source.sendFailure((Component)SkyComponents.DENIED_DELETE_TEAM);
            return 0;
        }
        HashSet<UUID> players = new HashSet<UUID>(data.getTeam(team).getPlayers());
        if (!data.deleteTeam(team)) {
            source.sendFailure((Component)SkyComponents.ERROR_DELETE_TEAM.apply(team));
            return 0;
        }
        PlayerList playerList = source.getServer().getPlayerList();
        Team spawn = data.getSpawn();
        players.forEach(id -> {
            ServerPlayer player = playerList.getPlayer(id);
            if (player != null) {
                if (InventoryConfig.dropItems) {
                    RandomUtility.dropInventories((Player)player);
                }
                WorldUtil.teleportToIsland(player, spawn);
            }
        });
        source.sendSuccess(() -> (Component)SkyComponents.SUCCESS_DELETE_ONE_TEAM.apply(team), true);
        return 1;
    }

    private static int addToTeam(CommandSourceStack source, String teamName, Collection<ServerPlayer> players) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.getLevel();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        if (!data.teamExists(teamName)) {
            source.sendFailure((Component)SkyComponents.ERROR_TEAM_NOT_EXIST);
            return 0;
        }
        Team island = data.getTeam(teamName);
        Pair<Boolean, Set<ServerPlayer>> result = SkyblockHooks.onManageAddToTeam(source, island, players);
        if (((Boolean)result.getLeft()).booleanValue()) {
            source.sendFailure((Component)SkyComponents.DENIED_ADD_PLAYERS_TO_TEAM);
            return 0;
        }
        ServerPlayer added = null;
        int i = 0;
        for (ServerPlayer addedPlayer : (Set)result.getRight()) {
            if (data.hasPlayerTeam((Player)addedPlayer)) continue;
            data.addPlayerToTeam(teamName, (Player)addedPlayer);
            WorldUtil.teleportToIsland(addedPlayer, island);
            if (i == 0) {
                added = addedPlayer;
            }
            ++i;
        }
        if (i == 0) {
            source.sendFailure((Component)SkyComponents.ERROR_NO_PLAYER_ADDED);
            return 0;
        }
        if (i == 1) {
            String playerName = added.getDisplayName().getString();
            source.sendSuccess(() -> (Component)SkyComponents.SUCCESS_ADD_ONE_PLAYER.apply(playerName, teamName), true);
        } else {
            int playerAmount = i;
            source.sendSuccess(() -> (Component)SkyComponents.SUCCESS_ADD_MULTIPLE_PLAYERS.apply(playerAmount, teamName), true);
        }
        return 1;
    }

    private static int removeFromTeam(CommandSourceStack source, ServerPlayer player) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.getLevel();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        Team team = data.getTeamFromPlayer((Player)player);
        if (team == null) {
            source.sendFailure((Component)SkyComponents.ERROR_PLAYER_HAS_NO_TEAM);
            return 0;
        }
        Pair<Boolean, Set<ServerPlayer>> result = SkyblockHooks.onManageRemoveFromTeam(source, team, (Collection<ServerPlayer>)ImmutableSet.of((Object)player));
        if (((Boolean)result.getLeft()).booleanValue()) {
            source.sendFailure((Component)SkyComponents.DENIED_REMOVE_PLAYERS_FROM_TEAM);
            return 0;
        }
        String teamName = team.getName();
        Team spawn = data.getSpawn();
        int i = 0;
        for (ServerPlayer target : (Set)result.getRight()) {
            if (!team.hasPlayer((Player)target)) continue;
            data.removePlayerFromTeam((Player)target);
            if (InventoryConfig.dropItems) {
                RandomUtility.dropInventories((Player)target);
            }
            WorldUtil.teleportToIsland(target, spawn);
            ++i;
        }
        RandomUtility.deleteTeamIfEmpty(data, team);
        int playerAmount = i;
        source.sendSuccess(() -> (Component)SkyComponents.SUCCESS_REMOVE_MULTIPLE_PLAYERS.apply(playerAmount, teamName), true);
        return 1;
    }
}

