/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.invitation;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.commands.Suggestions;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.events.SkyblockJoinRequestEvent;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.CommandUtil;
import de.melanx.skyblockbuilder.util.SkyComponents;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class JoinCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"join").then(Commands.argument((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.ALL_TEAMS).executes(context -> JoinCommand.sendJoinRequest((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"team"))));
    }

    private static int sendJoinRequest(CommandSourceStack source, String teamName) throws CommandSyntaxException {
        CommandUtil.ValidationResult validationResult = CommandUtil.validateTeamExistence(source, teamName);
        if (validationResult == null) {
            return 0;
        }
        ServerPlayer player = validationResult.player();
        Team team = validationResult.team();
        if (validationResult.data().hasPlayerTeam((Player)player)) {
            source.sendFailure((Component)SkyComponents.ERROR_USER_HAS_TEAM);
            return 0;
        }
        SkyblockJoinRequestEvent.SendRequest event = SkyblockHooks.onSendJoinRequest(player, team);
        switch (event.getResult()) {
            case DENY: {
                source.sendFailure((Component)SkyComponents.DENIED_JOIN_REQUEST);
                return 0;
            }
            case DEFAULT: {
                if (PermissionManager.INSTANCE.mayExecuteOpCommand((Player)player)) break;
                if (!PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TEAM_HANDLE_INVITES)) {
                    source.sendFailure((Component)SkyComponents.DISABLED_JOIN_REQUEST);
                    return 0;
                }
                if (team.allowsJoinRequests()) break;
                source.sendFailure((Component)SkyComponents.DISABLED_TEAM_JOIN_REQUEST);
                return 0;
            }
        }
        team.sendJoinRequest((Player)player);
        source.sendSuccess(() -> (Component)SkyComponents.SUCCESS_JOIN_REQUEST.apply(teamName), true);
        return 1;
    }
}

