/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.helper;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.melanx.skyblockbuilder.commands.Suggestions;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyComponents;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.moddingx.libx.command.CommandUtil;

public class LocateCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"locate").requires(PermissionManager.INSTANCE::mayExecuteOpCommand)).then(Commands.literal((String)"spread").then(((RequiredArgumentBuilder)Commands.argument((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.ALL_TEAMS).executes(LocateCommand::locateAllSpreads)).then(Commands.argument((String)"spread", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.SPREADS_FOR_TEAM).executes(LocateCommand::locateSpread))));
    }

    private static int locateSpread(CommandContext<CommandSourceStack> context) {
        String spreadName = (String)CommandUtil.getArgumentOrDefault(context, (String)"spread", String.class, (Object)"Spread");
        Team team = LocateCommand.getTeam(context);
        if (team == null) {
            return 0;
        }
        if (team.getPlacedSpreads(spreadName).isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)SkyComponents.ERROR_SPREAD_NOT_EXIST);
            return 0;
        }
        LocateCommand.sendLocations((CommandSourceStack)context.getSource(), team, spreadName);
        return 1;
    }

    private static int locateAllSpreads(CommandContext<CommandSourceStack> context) {
        Team team = LocateCommand.getTeam(context);
        if (team == null) {
            return 0;
        }
        Set<String> spreadNames = team.getAllSpreadNames();
        if (spreadNames.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)SkyComponents.ERROR_NO_SPREADS);
            return 0;
        }
        spreadNames.forEach(spreadName -> LocateCommand.sendLocations((CommandSourceStack)context.getSource(), team, spreadName));
        return spreadNames.size();
    }

    private static void sendLocations(CommandSourceStack source, Team team, String spreadName) {
        source.sendSuccess(() -> {
            MutableComponent msg = SkyComponents.SUCCESS_LOCATED_SPREAD.apply(spreadName);
            for (Team.PlacedSpread spread : team.getPlacedSpreads(spreadName)) {
                msg.append("\n- ");
                msg.append(RandomUtility.getFormattedPos(spread.pos()));
            }
            return msg;
        }, true);
    }

    private static Team getTeam(CommandContext<CommandSourceStack> context) {
        String teamName = (String)CommandUtil.getArgumentOrDefault(context, (String)"team", String.class, (Object)"Spawn");
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        Team team = data.getTeam(teamName);
        if (team == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)SkyComponents.ERROR_TEAM_NOT_EXIST);
        }
        return team;
    }
}

