/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.client.screen.ScreenMouseEvent;
import net.blay09.mods.inventoryessentials.InventoryEssentials;
import net.blay09.mods.inventoryessentials.InventoryEssentialsConfig;
import net.blay09.mods.inventoryessentials.client.ClientOnlyInventoryControls;
import net.blay09.mods.inventoryessentials.client.CreativeInventoryControls;
import net.blay09.mods.inventoryessentials.client.InventoryControls;
import net.blay09.mods.inventoryessentials.client.ModKeyMappings;
import net.blay09.mods.inventoryessentials.client.ServerSupportedInventoryControls;
import net.blay09.mods.inventoryessentials.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.inventoryessentials.mixin.CreativeModeInventoryScreenAccessor;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;

public class InventoryEssentialsClient {
    private static final InventoryControls clientOnlyControls = new ClientOnlyInventoryControls();
    private static final InventoryControls creativeControls = new CreativeInventoryControls();
    private static final InventoryControls serverSupportedControls = new ServerSupportedInventoryControls();
    private static Slot lastDragHoverSlot;

    public static void initialize() {
        ModKeyMappings.initialize();
        Balm.getEvents().onEvent(ScreenMouseEvent.Drag.Pre.class, InventoryEssentialsClient::onMouseDrag);
    }

    public static InventoryControls getInventoryControls(Screen screen) {
        if (screen instanceof CreativeModeInventoryScreenAccessor) {
            return creativeControls;
        }
        return InventoryEssentials.isServerSideInstalled && !InventoryEssentialsConfig.getActive().forceClientImplementation ? serverSupportedControls : clientOnlyControls;
    }

    public static boolean shouldHandleInput(Screen screen) {
        if (!(screen instanceof AbstractContainerScreenAccessor)) {
            return false;
        }
        AbstractContainerScreenAccessor accessor = (AbstractContainerScreenAccessor)screen;
        Slot hoverSlot = accessor.getHoveredSlot();
        if (hoverSlot instanceof ResultSlot) {
            return false;
        }
        if (screen instanceof CreativeModeInventoryScreenAccessor) {
            CreativeModeInventoryScreenAccessor creativeAccessor = (CreativeModeInventoryScreenAccessor)screen;
            return hoverSlot == null || hoverSlot.container instanceof Inventory || hoverSlot.container != creativeAccessor.getCONTAINER();
        }
        return true;
    }

    public static void onMouseDrag(ScreenMouseEvent.Drag.Pre event) {
        if (ModKeyMappings.keyDragTransfer.isActiveAndDown()) {
            Screen screen = event.getScreen();
            if (screen instanceof AbstractContainerScreen) {
                AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
                Slot hoverSlot = ((AbstractContainerScreenAccessor)screen2).getHoveredSlot();
                if (hoverSlot == null || !InventoryEssentialsClient.shouldHandleInput((Screen)screen2) || !InventoryEssentialsClient.shouldHandleSlot(hoverSlot)) {
                    return;
                }
                if (hoverSlot.hasItem() && hoverSlot != lastDragHoverSlot) {
                    InventoryControls controls = InventoryEssentialsClient.getInventoryControls((Screen)screen2);
                    if (InventoryEssentialsConfig.getActive().enableShiftDrag) {
                        controls.dragTransfer(screen2, hoverSlot);
                    }
                    lastDragHoverSlot = hoverSlot;
                }
            }
        } else {
            lastDragHoverSlot = null;
        }
    }

    private static boolean shouldHandleSlot(Slot slot) {
        return slot.container != null && slot.container.getContainerSize() != 0;
    }
}

