/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.cloche.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record SpeedUpgradeRecipe(Ingredient ingredient, String modifierType, int duration) implements Recipe<RecipeInput>
{
    public boolean matches(@NotNull RecipeInput container, @NotNull Level level) {
        ItemStack upgradeSlot1 = container.getItem(3);
        ItemStack upgradeSlot2 = container.getItem(4);
        ItemStack upgradeSlot3 = container.getItem(5);
        return this.ingredient.test(upgradeSlot1) || this.ingredient.test(upgradeSlot2) || this.ingredient.test(upgradeSlot3);
    }

    public ItemStack assemble(RecipeInput p_345149_, HolderLookup.Provider p_346030_) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider p_336125_) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<SpeedUpgradeRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<SpeedUpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(SpeedUpgradeRecipe::ingredient), (App)Codec.STRING.fieldOf("modifier_type").forGetter(SpeedUpgradeRecipe::modifierType), (App)Codec.INT.fieldOf("modifier").forGetter(SpeedUpgradeRecipe::duration)).apply((Applicative)instance, SpeedUpgradeRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, SpeedUpgradeRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<SpeedUpgradeRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, SpeedUpgradeRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static SpeedUpgradeRecipe read(RegistryFriendlyByteBuf buffer) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            String type = buffer.readUtf(Short.MAX_VALUE);
            int modifier = buffer.readInt();
            return new SpeedUpgradeRecipe(ingredient, type, modifier);
        }

        private static void write(RegistryFriendlyByteBuf buffer, SpeedUpgradeRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
            buffer.writeUtf(recipe.modifierType);
            buffer.writeInt(recipe.duration);
        }
    }

    public static class Type
    implements RecipeType<SpeedUpgradeRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

