/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.cloche.block.entity.client;

import com.benbenlaw.cloche.block.entity.ClocheBlockEntity;
import com.benbenlaw.core.block.brightable.BrightBlock;
import com.benbenlaw.core.block.brightable.BrightSapling;
import com.benbenlaw.core.block.colored.util.ColorMap;
import com.benbenlaw.core.block.colored.util.IColored;
import com.benbenlaw.core.item.CoreDataComponents;
import com.benbenlaw.core.util.CoreTags;
import com.benbenlaw.core.util.RenderUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;

public class ClocheBlockEntityRenderer
implements BlockEntityRenderer<ClocheBlockEntity> {
    public ClocheBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ClocheBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        Item buffer;
        Item model;
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        BlockRenderDispatcher blockRenderDispatcher = Minecraft.getInstance().getBlockRenderer();
        ItemStack soilStack = pBlockEntity.getSoil();
        ItemStack seedStack = pBlockEntity.getSeed();
        Item item = soilStack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            BlockState soilAsBlock = blockItem.getBlock().defaultBlockState();
            model = Minecraft.getInstance().getBlockRenderer().getBlockModel(soilAsBlock);
            RandomSource consistentRandom = RandomSource.create((long)pBlockEntity.getBlockPos().getX());
            List topOfBlock = model.getQuads(soilAsBlock, Direction.UP, consistentRandom, ModelData.builder().build(), RenderType.solid());
            buffer = pBufferSource.getBuffer(RenderType.solid());
            pPoseStack.pushPose();
            pPoseStack.scale(0.9f, 0.9f, 0.9f);
            pPoseStack.translate(0.05f, -0.92f, 0.05f);
            int tintColor = 0xFFFFFF;
            if (blockItem.getBlock() instanceof BrightBlock) {
                ItemStack stack = pBlockEntity.getSoil();
                for (String colorTag : CoreTags.Blocks.COLOR_TAGS.keySet()) {
                    if (!stack.is((TagKey)CoreTags.Items.COLOR_TAGS.get(colorTag))) continue;
                    DyeColor dyeColor = DyeColor.valueOf((String)colorTag.toUpperCase());
                    tintColor = ColorMap.getColorValue((DyeColor)dyeColor);
                }
            }
            float red = (float)(tintColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(tintColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(tintColor & 0xFF) / 255.0f;
            for (BakedQuad quad : topOfBlock) {
                buffer.putBulkData(pPoseStack.last(), quad, red, green, blue, 1.0f, pPackedLight, pPackedOverlay);
            }
            pPoseStack.popPose();
        }
        if ((model = soilStack.getItem()) instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)model;
            Fluid fluid = bucketItem.content.defaultFluidState().getType();
            VertexConsumer buffer2 = pBufferSource.getBuffer(Sheets.translucentCullBlockSheet());
            ClocheBlockEntityRenderer.renderFluid(pPoseStack.last(), buffer2, (BlockEntity)pBlockEntity, fluid, 0.05f, pPackedLight);
        }
        int progress = pBlockEntity.progress;
        int maxProgress = pBlockEntity.maxProgress;
        buffer = seedStack.getItem();
        if (buffer instanceof BlockItem) {
            Block dyeColor2;
            String colorName;
            BlockItem blockItem = (BlockItem)buffer;
            BlockState seedAsBlock = blockItem.getBlock().defaultBlockState();
            int tintColor = 0xFFFFFF;
            if (blockItem.getBlock() instanceof IColored && (colorName = (String)seedStack.get((DataComponentType)CoreDataComponents.COLOR.get())) != null) {
                DyeColor dyeColor2 = DyeColor.valueOf((String)colorName.toUpperCase());
                tintColor = ColorMap.getColorValue((DyeColor)dyeColor2);
            }
            if (blockItem.getBlock() instanceof BrightSapling) {
                ItemStack stack = pBlockEntity.getSeed();
                for (String colorTag : CoreTags.Blocks.COLOR_TAGS.keySet()) {
                    if (!stack.is((TagKey)CoreTags.Items.COLOR_TAGS.get(colorTag))) continue;
                    DyeColor dyeColor3 = DyeColor.valueOf((String)colorTag.toUpperCase());
                    tintColor = ColorMap.getColorValue((DyeColor)dyeColor3);
                }
            }
            if ((dyeColor2 = seedAsBlock.getBlock()) instanceof CropBlock) {
                CropBlock ageCropBlock = (CropBlock)dyeColor2;
                int maxAge = ageCropBlock.getMaxAge();
                int age = Math.round((float)progress / (float)maxProgress * (float)maxAge);
                IntegerProperty ageProperty = null;
                for (Property property : ageCropBlock.getStateDefinition().getProperties()) {
                    IntegerProperty integerProperty;
                    if (!(property instanceof IntegerProperty) || !(integerProperty = (IntegerProperty)property).getPossibleValues().contains(age)) continue;
                    ageProperty = integerProperty;
                    break;
                }
                if (ageProperty instanceof IntegerProperty) {
                    IntegerProperty integerProperty = ageProperty;
                    BlockState seedAsBlockCrop = (BlockState)seedAsBlock.setValue((Property)integerProperty, (Comparable)Integer.valueOf(age));
                    pPoseStack.pushPose();
                    pPoseStack.scale(0.8f, 0.8f, 0.8f);
                    pPoseStack.translate(0.1f, 0.1f, 0.1f);
                    this.renderWithTint(blockRenderDispatcher, seedAsBlockCrop, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, tintColor);
                    pPoseStack.popPose();
                }
            } else if (seedAsBlock.getBlock() instanceof StemBlock) {
                int maxAge = 7;
                int age = Math.round((float)progress / (float)maxProgress * (float)maxAge);
                age = Math.min(age, maxAge);
                BlockState seedAsBlockCrop = (BlockState)seedAsBlock.setValue((Property)BlockStateProperties.AGE_7, (Comparable)Integer.valueOf(age));
                pPoseStack.pushPose();
                pPoseStack.scale(0.8f, 0.8f, 0.8f);
                pPoseStack.translate(0.1f, 0.1f, 0.1f);
                this.renderWithTint(blockRenderDispatcher, seedAsBlockCrop, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, tintColor);
                pPoseStack.popPose();
            } else {
                pPoseStack.pushPose();
                float growthProgress = (float)progress / (float)maxProgress;
                float minScale = 0.3f;
                float maxScale = 0.6f;
                float scale = minScale + growthProgress * (maxScale - minScale);
                pPoseStack.translate(0.5f, 0.1f, 0.5f);
                pPoseStack.scale(scale, scale, scale);
                pPoseStack.translate(-0.5f, 0.0f, -0.5f);
                this.renderWithTint(blockRenderDispatcher, seedAsBlock, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, tintColor);
                pPoseStack.popPose();
            }
        }
    }

    private int getLightLevel(Level level, BlockPos pos) {
        int bLight = level.getBrightness(LightLayer.BLOCK, pos);
        int sLight = level.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)bLight, (int)sLight);
    }

    private void renderWithTint(BlockRenderDispatcher blockRenderDispatcher, BlockState state, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, int tintColor) {
        float r = (float)(tintColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(tintColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(tintColor & 0xFF) / 255.0f;
        blockRenderDispatcher.getModelRenderer().renderModel(poseStack.last(), bufferSource.getBuffer(RenderType.cutout()), state, blockRenderDispatcher.getBlockModel(state), r, g, b, packedLight, packedOverlay, ModelData.EMPTY, null);
    }

    private static void renderFluid(PoseStack.Pose pose, VertexConsumer consumer, BlockEntity entity, Fluid fluid, float fillAmount, int packedLight) {
        int color = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(fluid.defaultFluidState(), (BlockAndTintGetter)entity.getLevel(), entity.getBlockPos());
        ClocheBlockEntityRenderer.renderFluid(pose, consumer, fluid, fillAmount, color, packedLight);
    }

    public static void renderFluid(PoseStack.Pose pose, VertexConsumer consumer, Fluid fluid, float fillAmount, int color, int packedLight) {
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluid);
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(props.getStillTexture());
        float fluidHeight = 14.0f * fillAmount / 16.0f;
        float inset = 0.0625f;
        float faceSize = 0.875f;
        RenderUtil.renderFace((Direction)Direction.SOUTH, (PoseStack.Pose)pose, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)inset, (float)inset, (float)faceSize, (float)fluidHeight, (int)color, (int)packedLight);
        RenderUtil.renderFace((Direction)Direction.NORTH, (PoseStack.Pose)pose, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)inset, (float)inset, (float)faceSize, (float)fluidHeight, (int)color, (int)packedLight);
        RenderUtil.renderFace((Direction)Direction.EAST, (PoseStack.Pose)pose, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)inset, (float)inset, (float)faceSize, (float)fluidHeight, (int)color, (int)packedLight);
        RenderUtil.renderFace((Direction)Direction.WEST, (PoseStack.Pose)pose, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)inset, (float)inset, (float)faceSize, (float)fluidHeight, (int)color, (int)packedLight);
        RenderUtil.renderFace((Direction)Direction.UP, (PoseStack.Pose)pose, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)inset, (float)(inset + fluidHeight), (float)faceSize, (float)faceSize, (int)color, (int)packedLight);
        RenderUtil.renderFace((Direction)Direction.DOWN, (PoseStack.Pose)pose, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)inset, (float)(1.0f - inset), (float)faceSize, (float)faceSize, (int)color, (int)packedLight);
    }
}

