/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.menu;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.compat.ae2.AppliedEnergisticsCompat;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCalculation;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeMatchResult;
import xfacthd.framedblocks.common.menu.FramingSawWithEncoderMenu;
import xfacthd.framedblocks.common.menu.IFramingSawMenu;
import xfacthd.framedblocks.common.util.FramedUtils;

public class FramingSawMenu
extends AbstractContainerMenu
implements IFramingSawMenu {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_ADDITIVE_FIRST = 1;
    public static final int SLOT_RESULT = 4;
    public static final int SLOT_INV_FIRST = 5;
    public static final int INV_SLOT_COUNT = 36;
    public static final int TOTAL_SLOT_COUNT = 41;
    protected final Level level;
    private final Slot inputSlot;
    private final Slot[] additiveSlots;
    private final Slot resultSlot;
    protected final ContainerLevelAccess levelAccess;
    protected final FrameCrafterContainer inputContainer = new FrameCrafterContainer(this);
    private final ResultContainer resultContainer = new ResultContainer();
    private final DataSlot selectedRecipeIdx = DataSlot.standalone();
    private final FramingSawRecipeCache cache;
    private final List<FramedRecipeHolder> recipes;
    private final ItemStack[] lastAdditives;
    private ItemStack lastInput = ItemStack.EMPTY;
    private FramingSawRecipe selectedRecipe = null;
    private boolean recipeChanged = false;

    protected FramingSawMenu(int containerId, Inventory inv, ContainerLevelAccess levelAccess) {
        super((MenuType)FBContent.MENU_TYPE_FRAMING_SAW.value(), containerId);
        this.level = inv.player.level();
        this.levelAccess = levelAccess;
        this.inputSlot = this.addSlot(new CraftingSlot(this, (Container)this.inputContainer, 0, 20, 28));
        this.additiveSlots = new CraftingSlot[3];
        for (int i = 0; i < this.additiveSlots.length; ++i) {
            int y = 64 + i * 18;
            this.additiveSlots[i] = this.addSlot(new CraftingSlot(this, (Container)this.inputContainer, 1 + i, 20, y));
        }
        this.resultSlot = this.addSlot(new ResultSlot(this, (Container)this.resultContainer, 0, 223, 64));
        this.lastAdditives = new ItemStack[3];
        Arrays.fill(this.lastAdditives, ItemStack.EMPTY);
        FramedUtils.addPlayerInvSlots(x$0 -> this.addSlot((Slot)x$0), inv, 48, 151);
        this.addDataSlot(this.selectedRecipeIdx);
        this.cache = FramingSawRecipeCache.get(this.level.isClientSide());
        this.recipes = this.cache.getRecipes().stream().map(FramedRecipeHolder::new).toList();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack remainder = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            remainder = stack.copy();
            if (index == 4) {
                stack.getItem().onCraftedBy(stack, player.level(), player);
                if (!this.moveItemStackTo(stack, 5, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(stack, remainder);
            } else if (index < 5 ? !this.moveItemStackTo(stack, 5, 41, true) : (this.cache.getMaterialValue(stack.getItem()) > 0 ? !this.moveItemStackTo(stack, 0, 1, false) : !this.moveItemStackTo(stack, 1, 4, false))) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack.getCount() == remainder.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stack);
            this.broadcastChanges();
        }
        return remainder;
    }

    public boolean clickMenuButton(Player player, int id) {
        if (this.isValidRecipeIndex(id)) {
            this.selectedRecipeIdx.set(id);
            this.selectedRecipe = this.recipes.get(id).getRecipe();
            if (this.isCraftingEnabled()) {
                this.setupResultSlot();
            }
            this.recipeChanged = true;
        }
        return true;
    }

    public void slotsChanged(Container inventory) {
        boolean changed = false;
        ItemStack input = this.inputSlot.getItem();
        if (!input.is(this.lastInput.getItem()) || input.getCount() != this.lastInput.getCount()) {
            this.lastInput = input.copy();
            changed = true;
        }
        for (int i = 0; i < this.additiveSlots.length; ++i) {
            ItemStack additive = this.additiveSlots[i].getItem();
            if (additive.is(this.lastAdditives[i].getItem()) && additive.getCount() == this.lastAdditives[i].getCount()) continue;
            this.lastAdditives[i] = additive.copy();
            changed = true;
        }
        if (changed) {
            for (FramedRecipeHolder holder : this.recipes) {
                holder.matchResult = holder.getRecipe().matchWithResult(this.inputContainer, this.level);
            }
            this.setupResultSlot();
        }
    }

    private void setupResultSlot() {
        if (this.isValidRecipeIndex(this.selectedRecipeIdx.get())) {
            FramedRecipeHolder holder = this.recipes.get(this.selectedRecipeIdx.get());
            if (holder.matchResult.success()) {
                FramingSawRecipe recipe = holder.getRecipe();
                FramingSawRecipeCalculation calc = recipe.makeCraftingCalculation(this.inputContainer, this.level.isClientSide());
                ItemStack result = recipe.assemble(this.inputContainer, (HolderLookup.Provider)this.level.registryAccess());
                result.setCount(calc.getOutputCount());
                this.resultContainer.setRecipeUsed(holder.vanillaHolder);
                this.resultSlot.set(result);
                this.selectedRecipe = recipe;
                this.broadcastChanges();
                return;
            }
        }
        this.resultSlot.set(ItemStack.EMPTY);
        this.selectedRecipe = null;
        this.broadcastChanges();
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot.index != 4 && slot.isActive();
    }

    public boolean stillValid(Player player) {
        return FramingSawMenu.stillValid((ContainerLevelAccess)this.levelAccess, (Player)player, (Block)((Block)FBContent.BLOCK_FRAMING_SAW.value()));
    }

    public void removed(Player player) {
        super.removed(player);
        this.resultContainer.removeItemNoUpdate(1);
        this.levelAccess.execute((level, pos) -> this.clearContainer(player, (Container)this.inputContainer));
    }

    @Override
    public RecipeInput getRecipeInput() {
        return this.inputContainer;
    }

    @Override
    public ItemStack getInputStack() {
        return this.inputSlot.getItem();
    }

    @Override
    public ItemStack getAdditiveStack(int slot) {
        return this.additiveSlots[slot].getItem();
    }

    public List<FramedRecipeHolder> getRecipes() {
        return this.recipes;
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIdx.get();
    }

    public boolean hasRecipeChanged() {
        boolean changed = this.recipeChanged;
        this.recipeChanged = false;
        return changed;
    }

    @Override
    public boolean isValidRecipeIndex(int idx) {
        return idx >= 0 && idx < this.recipes.size();
    }

    protected boolean isCraftingEnabled() {
        return true;
    }

    public static FramingSawMenu create(int containerId, Inventory inv, ContainerLevelAccess levelAccess) {
        if (AppliedEnergisticsCompat.isLoaded()) {
            return new FramingSawWithEncoderMenu(containerId, inv, levelAccess);
        }
        return new FramingSawMenu(containerId, inv, levelAccess);
    }

    protected static class FrameCrafterContainer
    extends SimpleContainer
    implements RecipeInput {
        private final FramingSawMenu menu;

        FrameCrafterContainer(FramingSawMenu menu) {
            super(4);
            this.menu = menu;
        }

        public void setChanged() {
            super.setChanged();
            this.menu.slotsChanged((Container)this);
        }

        public int size() {
            return this.getContainerSize();
        }
    }

    private static class CraftingSlot
    extends Slot {
        private final FramingSawMenu menu;

        public CraftingSlot(FramingSawMenu menu, Container pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
            this.menu = menu;
        }

        public boolean isActive() {
            return this.menu.isCraftingEnabled();
        }
    }

    private static class ResultSlot
    extends CraftingSlot {
        private final FramingSawMenu menu;

        ResultSlot(FramingSawMenu menu, Container container, int index, int x, int y) {
            super(menu, container, index, x, y);
            this.menu = menu;
        }

        public boolean mayPlace(@NotNull ItemStack stack) {
            return false;
        }

        public void onTake(Player player, ItemStack stack) {
            stack.onCraftedBy(player.level(), player, stack.getCount());
            this.menu.resultContainer.awardUsedRecipes(player, List.of(this.menu.inputSlot.getItem(), this.menu.additiveSlots[0].getItem(), this.menu.additiveSlots[1].getItem(), this.menu.additiveSlots[2].getItem()));
            FramingSawRecipeCalculation calc = this.menu.selectedRecipe.makeCraftingCalculation(this.menu.inputContainer, this.menu.level.isClientSide());
            int additiveCount = this.menu.selectedRecipe.getAdditives().size();
            this.menu.inputSlot.remove(calc.getInputCount());
            for (int i = 0; i < additiveCount; ++i) {
                this.menu.additiveSlots[i].remove(calc.getAdditiveCount(i));
            }
            super.onTake(player, stack);
        }
    }

    public static final class FramedRecipeHolder {
        private final RecipeHolder<FramingSawRecipe> vanillaHolder;
        private FramingSawRecipeMatchResult matchResult = FramingSawRecipeMatchResult.MATERIAL_VALUE;

        private FramedRecipeHolder(RecipeHolder<FramingSawRecipe> holder) {
            this.vanillaHolder = holder;
        }

        public RecipeHolder<FramingSawRecipe> toVanilla() {
            return this.vanillaHolder;
        }

        public FramingSawRecipe getRecipe() {
            return (FramingSawRecipe)this.vanillaHolder.value();
        }

        public FramingSawRecipeMatchResult getMatchResult() {
            return this.matchResult;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && obj.getClass() == this.getClass()) {
                return this.vanillaHolder.id().equals((Object)((FramedRecipeHolder)obj).vanillaHolder.id());
            }
            return false;
        }

        public int hashCode() {
            return this.vanillaHolder.id().hashCode();
        }
    }
}

