/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen.builders.book.chapter;

import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xfacthd.framedblocks.common.datagen.builders.book.chapter.SectionBuilder;
import xfacthd.framedblocks.common.datagen.builders.book.includes.IncludeHolder;
import xfacthd.framedblocks.common.datagen.builders.book.primitives.BookRoot;
import xfacthd.framedblocks.common.datagen.builders.book.primitives.Identifiable;
import xfacthd.framedblocks.common.datagen.builders.book.primitives.Printable;
import xfacthd.framedblocks.common.datagen.builders.book.primitives.Validatable;

public final class ChapterBuilder
extends IncludeHolder<ChapterBuilder>
implements Printable,
Validatable,
Identifiable {
    private final String id;
    private final Map<String, SectionBuilder> sections = new LinkedHashMap<String, SectionBuilder>();
    private String condition = null;

    public ChapterBuilder(String id) {
        this.id = id;
    }

    public ChapterBuilder section(SectionBuilder section) {
        SectionBuilder prev = this.sections.put(section.getName(), section);
        if (prev != null) {
            throw new IllegalStateException("Condition with name '" + prev.getName() + "' registered twice");
        }
        return this;
    }

    public ChapterBuilder condition(String condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public void validate(BookRoot book) {
        if (this.condition != null && !book.hasCondition(this.condition)) {
            throw new IllegalArgumentException("Unknown condition: " + this.condition);
        }
        this.sections.forEach((id, section) -> section.validate(book));
    }

    @Override
    public void print(Document doc, Element bookElem) {
        Element chapterElem = doc.createElement("chapter");
        chapterElem.setAttribute("id", this.id);
        if (this.condition != null) {
            chapterElem.setAttribute("condition", this.condition);
        }
        this.sections.forEach((id, section) -> section.print(doc, chapterElem));
        this.includes.forEach((name, inc) -> inc.print(doc, bookElem));
        bookElem.appendChild(chapterElem);
    }
}

