/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slopepanel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slopepanel.FlatSlopePanelCornerShapes;

public final class FlatInverseDoubleSlopePanelCornerShapes
implements SplitShapeGenerator {
    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return FlatInverseDoubleSlopePanelCornerShapes.generate(states, FlatSlopePanelCornerShapes.SHAPES, FlatSlopePanelCornerShapes.INNER_SHAPES);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return FlatInverseDoubleSlopePanelCornerShapes.generate(states, FlatSlopePanelCornerShapes.OCCLUSION_SHAPES, FlatSlopePanelCornerShapes.INNER_OCCLUSION_SHAPES);
    }

    private static ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<FlatSlopePanelCornerShapes.ShapeKey> cache, ShapeCache<FlatSlopePanelCornerShapes.ShapeKey> innerCache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape[] shapes = new VoxelShape[16];
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape frontShape = cache.get(new FlatSlopePanelCornerShapes.ShapeKey(rot.getOpposite(), true));
            HorizontalRotation backRot = rot.rotate(rot.isVertical() ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90);
            VoxelShape backShape = innerCache.get(new FlatSlopePanelCornerShapes.ShapeKey(backRot, true));
            backShape = ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.SOUTH, backShape);
            VoxelShape preShape = ShapeUtils.orUnoptimized(frontShape, backShape);
            ShapeUtils.makeHorizontalRotations(preShape, Direction.NORTH, shapes, rot.ordinal() << 2);
        }
        for (BlockState state : states) {
            HorizontalRotation rot;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            int idx = dir.get2DDataValue() | rot.ordinal() << 2;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

