/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.capability;

import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import xfacthd.framedblocks.common.capability.IStorageBlockItemHandler;
import xfacthd.framedblocks.common.menu.FramedStorageMenu;

public final class CompoundStorageBlockItemHandler
implements IStorageBlockItemHandler {
    private final IStorageBlockItemHandler innerOne;
    private final IStorageBlockItemHandler innerTwo;

    public CompoundStorageBlockItemHandler(IStorageBlockItemHandler innerOne, IStorageBlockItemHandler innerTwo) {
        this.innerOne = innerOne;
        this.innerTwo = innerTwo;
    }

    public int getSlots() {
        return this.innerOne.getSlots() + this.innerTwo.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        int sizeOne = this.innerOne.getSlots();
        if (slot < sizeOne) {
            return this.innerOne.getStackInSlot(slot);
        }
        return this.innerTwo.getStackInSlot(slot - sizeOne);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        int sizeOne = this.innerOne.getSlots();
        if (slot < sizeOne) {
            this.innerOne.setStackInSlot(slot, stack);
        } else {
            this.innerTwo.setStackInSlot(slot - sizeOne, stack);
        }
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int sizeOne = this.innerOne.getSlots();
        if (slot < sizeOne) {
            return this.innerOne.insertItem(slot, stack, simulate);
        }
        return this.innerTwo.insertItem(slot - sizeOne, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int sizeOne = this.innerOne.getSlots();
        if (slot < sizeOne) {
            return this.innerOne.extractItem(slot, amount, simulate);
        }
        return this.innerTwo.extractItem(slot - sizeOne, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        int sizeOne = this.innerOne.getSlots();
        if (slot < sizeOne) {
            return this.innerOne.getSlotLimit(slot);
        }
        return this.innerTwo.getSlotLimit(slot - sizeOne);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        int sizeOne = this.innerOne.getSlots();
        if (slot < sizeOne) {
            return this.innerOne.isItemValid(slot, stack);
        }
        return this.innerTwo.isItemValid(slot - sizeOne, stack);
    }

    @Override
    public FramedStorageMenu createMenu(int windowId, Inventory inv) {
        return FramedStorageMenu.createDouble(windowId, inv, this);
    }

    @Override
    public boolean stillValid(Player player) {
        return this.innerOne.stillValid(player) && this.innerTwo.stillValid(player);
    }

    @Override
    public void open() {
        this.innerOne.open();
        this.innerTwo.open();
    }

    @Override
    public void close() {
        this.innerOne.close();
        this.innerTwo.close();
    }
}

