/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopeedge;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.ExtPlacementStateBuilder;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.StairsType;

public class FramedStackedCornerSlopeEdgeBlock
extends AbstractFramedDoubleBlock {
    public FramedStackedCornerSlopeEdgeBlock() {
        super(BlockType.FRAMED_STACKED_CORNER_SLOPE_EDGE);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.CORNER_TYPE, FramedProperties.Y_SLOPE, BlockStateProperties.WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((ExtPlacementStateBuilder)ExtPlacementStateBuilder.of(this, ctx).withHorizontalFacingAndCornerType().withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction side, Rotation rot) {
        CornerType type = (CornerType)((Object)state.getValue(PropertyHolder.CORNER_TYPE));
        if (type.isHorizontal()) {
            return (BlockState)state.setValue(PropertyHolder.CORNER_TYPE, (Comparable)((Object)type.rotate(rot)));
        }
        return this.rotate(state, rot);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        Direction dir = rot.rotate((Direction)state.getValue((Property)FramedProperties.FACING_HOR));
        return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        CornerType type = (CornerType)((Object)state.getValue(PropertyHolder.CORNER_TYPE));
        if (type.isHorizontal()) {
            BlockState newState = Utils.mirrorFaceBlock(state, mirror);
            if (newState != state) {
                return (BlockState)newState.setValue(PropertyHolder.CORNER_TYPE, (Comparable)((Object)type.horizontalOpposite()));
            }
            return state;
        }
        return Utils.mirrorCornerBlock(state, mirror);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedDoubleBlockEntity(pos, state);
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.defaultBlockState();
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        if (state.getValue(PropertyHolder.CORNER_TYPE) == CornerType.BOTTOM) {
            return DoubleBlockTopInteractionMode.FIRST;
        }
        return DoubleBlockTopInteractionMode.EITHER;
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        BlockState stateOne;
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        CornerType type = (CornerType)((Object)state.getValue(PropertyHolder.CORNER_TYPE));
        boolean ySlope = (Boolean)state.getValue((Property)FramedProperties.Y_SLOPE);
        if (type.isHorizontal()) {
            boolean right = type.isRight();
            StairsType stairsType = StairsType.get(!type.isTop(), right, !right);
            stateOne = (BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)(right ? dir.getClockWise() : dir))).setValue(PropertyHolder.STAIRS_TYPE, (Comparable)((Object)stairsType));
        } else {
            stateOne = (BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_STAIRS.value()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)dir)).setValue((Property)BlockStateProperties.HALF, (Comparable)(type.isTop() ? Half.TOP : Half.BOTTOM))).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT);
        }
        return new Tuple((Object)stateOne, (Object)((BlockState)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_CORNER_SLOPE_EDGE.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)).setValue(PropertyHolder.CORNER_TYPE, (Comparable)((Object)type))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))).setValue((Property)PropertyHolder.ALT_TYPE, (Comparable)Boolean.valueOf(true))));
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        Direction baseFace = switch ((CornerType)((Object)state.getValue(PropertyHolder.CORNER_TYPE))) {
            case CornerType.BOTTOM -> Direction.DOWN;
            case CornerType.TOP -> Direction.UP;
            default -> (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        };
        return side == baseFace ? SolidityCheck.FIRST : SolidityCheck.NONE;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction yBack;
        Direction xBack;
        Direction baseFace;
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        CornerType type = (CornerType)((Object)state.getValue(PropertyHolder.CORNER_TYPE));
        switch (type) {
            case BOTTOM: {
                Direction direction = Direction.DOWN;
                break;
            }
            case TOP: {
                Direction direction = Direction.UP;
                break;
            }
            default: {
                Direction direction = baseFace = dir;
            }
        }
        if (side == baseFace || edge == baseFace) {
            return CamoGetter.FIRST;
        }
        if (type.isHorizontal()) {
            xBack = type.isRight() ? dir.getClockWise() : dir.getCounterClockWise();
            yBack = type.isTop() ? Direction.UP : Direction.DOWN;
        } else {
            xBack = dir;
            yBack = dir.getCounterClockWise();
        }
        if (side == xBack && edge == yBack || side == yBack && edge == xBack) {
            return CamoGetter.FIRST;
        }
        return CamoGetter.NONE;
    }
}

