/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slope;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.ExtPlacementStateBuilder;
import xfacthd.framedblocks.common.blockentity.doubled.slope.FramedDoubleHalfSlopeBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.item.VerticalAndWallBlockItem;

public class FramedDoubleHalfSlopeBlock
extends AbstractFramedDoubleBlock {
    public FramedDoubleHalfSlopeBlock() {
        super(BlockType.FRAMED_DOUBLE_HALF_SLOPE);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.RIGHT, BlockStateProperties.WATERLOGGED, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((ExtPlacementStateBuilder)((ExtPlacementStateBuilder)ExtPlacementStateBuilder.of(this, ctx).withHorizontalFacing()).withRight().withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (rot == Rotation.NONE) {
            return state;
        }
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (Utils.isY(face)) {
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(facing));
        }
        if (face.getAxis() == facing.getAxis()) {
            return (BlockState)state.cycle((Property)PropertyHolder.RIGHT);
        }
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return this.rotate(state, Direction.UP, rotation);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (mirror == Mirror.FRONT_BACK && Utils.isX(dir) || mirror == Mirror.LEFT_RIGHT && Utils.isZ(dir)) {
            state = (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getOpposite());
        }
        return (BlockState)state.cycle((Property)PropertyHolder.RIGHT);
    }

    @Override
    public BlockItem createBlockItem() {
        return new VerticalAndWallBlockItem(this, (Block)FBContent.BLOCK_FRAMED_VERTICAL_DOUBLE_HALF_SLOPE.value(), new Item.Properties());
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        boolean right = (Boolean)state.getValue((Property)PropertyHolder.RIGHT);
        boolean ySlope = (Boolean)state.getValue((Property)FramedProperties.Y_SLOPE);
        BlockState defState = ((Block)FBContent.BLOCK_FRAMED_HALF_SLOPE.value()).defaultBlockState();
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)((BlockState)defState.setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(right))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)((BlockState)defState.setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing.getOpposite())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(!right))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        return DoubleBlockTopInteractionMode.SECOND;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction dirTwo;
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        boolean right = (Boolean)state.getValue((Property)PropertyHolder.RIGHT);
        Direction direction = dirTwo = right ? facing.getClockWise() : facing.getCounterClockWise();
        if (edge == dirTwo) {
            if (side == facing || side == Direction.DOWN) {
                return CamoGetter.FIRST;
            }
            if (side == facing.getOpposite() || side == Direction.UP) {
                return CamoGetter.SECOND;
            }
        } else if (side == dirTwo) {
            if (edge == facing || edge == Direction.DOWN) {
                return CamoGetter.FIRST;
            }
            if (edge == facing.getOpposite() || edge == Direction.UP) {
                return CamoGetter.SECOND;
            }
        }
        return CamoGetter.NONE;
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        boolean right = (Boolean)state.getValue((Property)PropertyHolder.RIGHT);
        if (!right && side == facing.getCounterClockWise() || right && side == facing.getClockWise()) {
            return SolidityCheck.BOTH;
        }
        return SolidityCheck.NONE;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedDoubleHalfSlopeBlockEntity(pos, state);
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.WEST);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }
}

