/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.interactive;

import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.api.util.Utils;

public class FramedLeverGeometry
extends Geometry {
    private static final float MIN_SMALL = 0.3125f;
    private static final float MAX_SMALL = 0.6875f;
    private static final float MIN_LARGE = 0.25f;
    private static final float MAX_LARGE = 0.75f;
    private static final float HEIGHT = 0.1875f;
    private final BlockState state;
    private final BakedModel baseModel;
    private final Direction dir;
    private final AttachFace face;

    public FramedLeverGeometry(GeometryFactory.Context ctx) {
        this.state = ctx.state();
        this.baseModel = ctx.baseModel();
        this.dir = (Direction)ctx.state().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        this.face = (AttachFace)ctx.state().getValue((Property)BlockStateProperties.ATTACH_FACE);
    }

    @Override
    public ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        return ModelUtils.getRenderTypes(Blocks.LEVER.defaultBlockState(), rand, extraData);
    }

    @Override
    public void getAdditionalQuads(QuadMap quadMap, RandomSource rand, ModelData data, RenderType renderType) {
        List quads = this.baseModel.getQuads(this.state, null, rand, data, renderType);
        for (BakedQuad quad : quads) {
            if (ClientUtils.isDummyTexture(quad)) continue;
            quadMap.get(null).add(quad);
        }
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction facing;
        boolean quadInDir;
        Direction quadDir = quad.getDirection();
        boolean bl = quadInDir = quadDir == (facing = this.getFacing());
        if (Utils.isY(facing)) {
            if (quadDir.getAxis() == facing.getAxis()) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getAxis(), 0.75f)).apply(Modifiers.cutTopBottom(this.dir.getClockWise().getAxis(), 0.6875f)).applyIf(Modifiers.setPosition(0.1875f), quadInDir).export(quadMap.get(quadInDir ? null : quadDir));
            } else {
                boolean smallSide = this.dir.getAxis() == quadDir.getAxis();
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(facing == Direction.DOWN, 0.1875f)).apply(Modifiers.cutSideLeftRight(smallSide ? 0.6875f : 0.75f)).apply(Modifiers.setPosition(smallSide ? 0.75f : 0.6875f)).export(quadMap.get(null));
            }
        } else if (quadDir.getAxis() == facing.getAxis()) {
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.3125f, 0.25f, 0.6875f, 0.75f)).applyIf(Modifiers.setPosition(0.1875f), quadInDir).export(quadMap.get(quadInDir ? null : quadDir));
        } else if (Utils.isY(quadDir)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.1875f)).apply(Modifiers.cutTopBottom(this.dir.getClockWise().getAxis(), 0.6875f)).apply(Modifiers.setPosition(0.75f)).export(quadMap.get(null));
        } else {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir, 0.1875f)).apply(Modifiers.cutSideUpDown(0.75f)).apply(Modifiers.setPosition(0.6875f)).export(quadMap.get(null));
        }
    }

    private Direction getFacing() {
        return switch (this.face) {
            default -> throw new MatchException(null, null);
            case AttachFace.FLOOR -> Direction.UP;
            case AttachFace.WALL -> this.dir;
            case AttachFace.CEILING -> Direction.DOWN;
        };
    }

    @Override
    public boolean useSolidNoCamoModel() {
        return true;
    }
}

