/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.block.render;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.camo.CamoContent;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.util.ConfigView;

public final class CullingHelper {
    public static boolean isSideHidden(BlockGetter level, BlockPos pos, BlockState state, Direction side) {
        IFramedBlock block;
        BlockPos adjPos = pos.relative(side);
        BlockState adjState = level.getBlockState(adjPos);
        boolean adjFramed = false;
        IFramedBlock adjBlock = null;
        Block block2 = adjState.getBlock();
        if (block2 instanceof IFramedBlock) {
            block = (IFramedBlock)block2;
            if (block.shouldPreventNeighborCulling(level, adjPos, adjState, pos, state)) {
                return false;
            }
            adjFramed = true;
            adjBlock = block;
        } else if (adjState.isSolidRender(level, adjPos)) {
            return false;
        }
        block = (IFramedBlock)state.getBlock();
        boolean fullFace = block.getCache(state).isFullFace(side);
        if (!adjFramed || fullFace || !ConfigView.Client.INSTANCE.detailedCullingEnabled()) {
            if (fullFace && (!adjFramed || adjBlock.getCache(adjState).isFullFace(side.getOpposite()))) {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (!(blockEntity instanceof FramedBlockEntity)) {
                    return false;
                }
                FramedBlockEntity be = (FramedBlockEntity)blockEntity;
                Object camoContent = be.getCamo(side).getContent();
                if (adjFramed) {
                    BlockEntity blockEntity2 = level.getBlockEntity(adjPos);
                    if (!(blockEntity2 instanceof FramedBlockEntity)) {
                        return false;
                    }
                    FramedBlockEntity adjBe = (FramedBlockEntity)blockEntity2;
                    Object adjCamoContent = adjBe.getCamo(side.getOpposite()).getContent();
                    return ((CamoContent)camoContent).isOccludedBy((CamoContent<?>)adjCamoContent, level, pos, adjPos);
                }
                return ((CamoContent)camoContent).isOccludedBy(adjState, level, pos, adjPos);
            }
            return false;
        }
        SideSkipPredicate pred = block.getBlockType().getSideSkipPredicate();
        BlockState adjTestState = adjBlock.runOcclusionTestAndGetLookupState(pred, level, pos, state, adjState, side);
        if (adjTestState != null) {
            BlockEntity blockEntity;
            Object adjCamoContent = level.getBlockEntity(adjPos);
            if (!(adjCamoContent instanceof FramedBlockEntity)) {
                return false;
            }
            FramedBlockEntity adjBe = (FramedBlockEntity)((Object)adjCamoContent);
            adjCamoContent = adjBe.getCamo(adjTestState).getContent();
            if (!((CamoContent)adjCamoContent).isEmpty() && (blockEntity = level.getBlockEntity(pos)) instanceof FramedBlockEntity) {
                FramedBlockEntity be = (FramedBlockEntity)blockEntity;
                Object camoContent = be.getCamo(state).getContent();
                return ((CamoContent)camoContent).isOccludedBy((CamoContent<?>)adjCamoContent, level, pos, adjPos);
            }
            return false;
        }
        return false;
    }

    public static boolean hidesNeighborFace(IFramedBlock block, BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (adjState.getBlock() instanceof IFramedBlock) {
            return false;
        }
        BlockPos adjPos = pos.relative(side);
        if (block.shouldPreventNeighborCulling(level, pos, state, adjPos, adjState)) {
            return false;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            if (((IFramedBlock)state.getBlock()).getCache(state).isFullFace(side)) {
                Object camoContent = be.getCamo(side).getContent();
                return ((CamoContent)camoContent).occludes(adjState, level, pos, adjPos);
            }
            return be.isSolidSide(side);
        }
        return false;
    }

    private CullingHelper() {
    }
}

