/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.logic.enums;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.xnet.utils.I18nConstants;
import mcjty.xnet.utils.I18nUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum SensorOperator implements ITranslatableEnum<SensorOperator>,
StringRepresentable
{
    EQUAL("=", Long::equals),
    NOTEQUAL("!=", (i1, i2) -> !i1.equals(i2)),
    LESS("<", (i1, i2) -> i1 < i2),
    GREATER(">", (i1, i2) -> i1 > i2),
    LESSOREQUAL("<=", (i1, i2) -> i1 <= i2),
    GREATEROREQUAL(">=", (i1, i2) -> i1 >= i2);

    public static final Codec<SensorOperator> CODEC;
    public static final StreamCodec<FriendlyByteBuf, SensorOperator> STREAM_CODEC;
    private static final Map<String, SensorOperator> NAME_MAP;
    private final String code;
    private final BiPredicate<Long, Long> matcher;

    private SensorOperator(String code, BiPredicate<Long, Long> matcher) {
        this.code = code;
        this.matcher = matcher;
    }

    public static SensorOperator byName(String name) {
        return NAME_MAP.get(name);
    }

    public boolean match(long i1, long i2) {
        return this.matcher.test(i1, i2);
    }

    public String toString() {
        return this.code;
    }

    public String getI18n() {
        return this.code;
    }

    public String[] getI18nSplitedTooltip() {
        return I18nUtils.getSplitedTooltip((String)I18nConstants.LOGIC_SENSOR_OPERATOR_TOOLTIP.i18n(new Object[0]));
    }

    @Nonnull
    public String getSerializedName() {
        return this.name();
    }

    static {
        CODEC = StringRepresentable.fromEnum(SensorOperator::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(SensorOperator.class);
        NAME_MAP = Arrays.stream(SensorOperator.values()).collect(Collectors.toMap(Enum::name, Function.identity()));
    }
}

