/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.util.entitiy;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.ObjIntConsumer;
import javax.annotation.Nullable;
import net.biorfn.compressedfurnace.config.Config;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.ApiStatus;

public class FuelManager {
    @Nullable
    private static volatile Map<Item, Integer> fuelCache;

    public static int calculateSmeltedItemCount(Item fuelItem, int defaultCookTime, String tierId) {
        Map<Item, Integer> fuelMap = FuelManager.getFuel();
        int burnTime = fuelMap.getOrDefault(fuelItem, 0);
        if (burnTime > 0) {
            double tierMultiplier = FuelManager.getTierMultiplier(tierId);
            int itemsSmelted = (int)((double)burnTime / (double)defaultCookTime * tierMultiplier);
            return itemsSmelted;
        }
        return 0;
    }

    public static Map<Item, Integer> getFuel() {
        Map<Item, Integer> map = fuelCache;
        if (map != null) {
            return map;
        }
        LinkedHashMap map1 = Maps.newLinkedHashMap();
        FuelManager.buildFuels((e, time) -> e.ifRight(tag -> FuelManager.add((Map<Item, Integer>)map1, (TagKey<Item>)tag, time)).ifLeft(item -> FuelManager.add((Map<Item, Integer>)map1, (ItemLike)item, time)));
        fuelCache = map1;
        return map1;
    }

    public static void add(ObjIntConsumer<Either<Item, TagKey<Item>>> consumer, ItemLike item, int time) {
        consumer.accept((Either<Item, TagKey<Item>>)Either.left((Object)item.asItem()), time);
    }

    public static void add(ObjIntConsumer<Either<Item, TagKey<Item>>> consumer, TagKey<Item> tag, int time) {
        consumer.accept((Either<Item, TagKey<Item>>)Either.right(tag), time);
    }

    @ApiStatus.Internal
    public static void buildFuels(ObjIntConsumer<Either<Item, TagKey<Item>>> map1) {
        FuelManager.add(map1, (ItemLike)Items.LAVA_BUCKET, 20000);
        FuelManager.add(map1, (ItemLike)Blocks.COAL_BLOCK, 16000);
        FuelManager.add(map1, (ItemLike)Items.BLAZE_ROD, 2400);
        FuelManager.add(map1, (ItemLike)Items.COAL, 1600);
        FuelManager.add(map1, (ItemLike)Items.CHARCOAL, 1600);
        FuelManager.add(map1, (TagKey<Item>)ItemTags.LOGS, 300);
        FuelManager.add(map1, (TagKey<Item>)ItemTags.BAMBOO_BLOCKS, 300);
        FuelManager.add(map1, (TagKey<Item>)ItemTags.PLANKS, 300);
        FuelManager.add(map1, (ItemLike)Blocks.BAMBOO_MOSAIC, 300);
        FuelManager.add(map1, (TagKey<Item>)ItemTags.WOODEN_STAIRS, 300);
        FuelManager.add(map1, (ItemLike)Blocks.BAMBOO_MOSAIC_STAIRS, 300);
        FuelManager.add(map1, (TagKey<Item>)ItemTags.WOODEN_SLABS, 150);
        FuelManager.add(map1, (ItemLike)Blocks.BAMBOO_MOSAIC_SLAB, 150);
        FuelManager.add(map1, (TagKey<Item>)ItemTags.WOODEN_TRAPDOORS, 300);
        FuelManager.add(map1, (TagKey<Item>)ItemTags.WOODEN_PRESSURE_PLATES, 300);
        FuelManager.add(map1, (TagKey<Item>)ItemTags.WOODEN_FENCES, 300);
        FuelManager.add(map1, (TagKey<Item>)ItemTags.FENCE_GATES, 300);
        FuelManager.add(map1, (ItemLike)Blocks.NOTE_BLOCK, 300);
        FuelManager.add(map1, (ItemLike)Blocks.BOOKSHELF, 300);
        FuelManager.add(map1, (ItemLike)Blocks.CHISELED_BOOKSHELF, 300);
        FuelManager.add(map1, (ItemLike)Blocks.LECTERN, 300);
        FuelManager.add(map1, (ItemLike)Blocks.JUKEBOX, 300);
        FuelManager.add(map1, (ItemLike)Blocks.CHEST, 300);
        FuelManager.add(map1, (ItemLike)Blocks.TRAPPED_CHEST, 300);
        FuelManager.add(map1, (ItemLike)Blocks.CRAFTING_TABLE, 300);
        FuelManager.add(map1, (ItemLike)Blocks.DAYLIGHT_DETECTOR, 300);
        FuelManager.add(map1, (TagKey<Item>)ItemTags.BANNERS, 300);
        FuelManager.add(map1, (ItemLike)Items.BOW, 300);
        FuelManager.add(map1, (ItemLike)Items.FISHING_ROD, 300);
        FuelManager.add(map1, (ItemLike)Blocks.LADDER, 300);
        FuelManager.add(map1, (TagKey<Item>)ItemTags.SIGNS, 200);
        FuelManager.add(map1, (TagKey<Item>)ItemTags.HANGING_SIGNS, 800);
        FuelManager.add(map1, (ItemLike)Items.WOODEN_SHOVEL, 200);
        FuelManager.add(map1, (ItemLike)Items.WOODEN_SWORD, 200);
        FuelManager.add(map1, (ItemLike)Items.WOODEN_HOE, 200);
        FuelManager.add(map1, (ItemLike)Items.WOODEN_AXE, 200);
        FuelManager.add(map1, (ItemLike)Items.WOODEN_PICKAXE, 200);
        FuelManager.add(map1, (TagKey<Item>)ItemTags.WOODEN_DOORS, 200);
        FuelManager.add(map1, (TagKey<Item>)ItemTags.BOATS, 1200);
        FuelManager.add(map1, (TagKey<Item>)ItemTags.WOOL, 100);
        FuelManager.add(map1, (TagKey<Item>)ItemTags.WOODEN_BUTTONS, 100);
        FuelManager.add(map1, (ItemLike)Items.STICK, 100);
        FuelManager.add(map1, (TagKey<Item>)ItemTags.SAPLINGS, 100);
        FuelManager.add(map1, (ItemLike)Items.BOWL, 100);
        FuelManager.add(map1, (TagKey<Item>)ItemTags.WOOL_CARPETS, 67);
        FuelManager.add(map1, (ItemLike)Blocks.DRIED_KELP_BLOCK, 4001);
        FuelManager.add(map1, (ItemLike)Items.CROSSBOW, 300);
        FuelManager.add(map1, (ItemLike)Blocks.BAMBOO, 50);
        FuelManager.add(map1, (ItemLike)Blocks.DEAD_BUSH, 100);
        FuelManager.add(map1, (ItemLike)Blocks.SCAFFOLDING, 50);
        FuelManager.add(map1, (ItemLike)Blocks.LOOM, 300);
        FuelManager.add(map1, (ItemLike)Blocks.BARREL, 300);
        FuelManager.add(map1, (ItemLike)Blocks.CARTOGRAPHY_TABLE, 300);
        FuelManager.add(map1, (ItemLike)Blocks.FLETCHING_TABLE, 300);
        FuelManager.add(map1, (ItemLike)Blocks.SMITHING_TABLE, 300);
        FuelManager.add(map1, (ItemLike)Blocks.COMPOSTER, 300);
        FuelManager.add(map1, (ItemLike)Blocks.AZALEA, 100);
        FuelManager.add(map1, (ItemLike)Blocks.FLOWERING_AZALEA, 100);
        FuelManager.add(map1, (ItemLike)Blocks.MANGROVE_ROOTS, 300);
    }

    public static boolean isNeverAFurnaceFuel(Item item) {
        return item.builtInRegistryHolder().is(ItemTags.NON_FLAMMABLE_WOOD);
    }

    public static void add(Map<Item, Integer> map, TagKey<Item> itemTag, int burnTime) {
        for (Holder holder : BuiltInRegistries.ITEM.getTagOrEmpty(itemTag)) {
            if (FuelManager.isNeverAFurnaceFuel((Item)holder.value())) continue;
            map.put((Item)holder.value(), burnTime);
        }
    }

    public static void add(Map<Item, Integer> map, ItemLike p_item, int burnTime) {
        Item item = p_item.asItem();
        if (FuelManager.isNeverAFurnaceFuel(item)) {
            if (SharedConstants.IS_RUNNING_IN_IDE) {
                throw (IllegalStateException)Util.pauseInIde((Throwable)new IllegalStateException("A developer tried to explicitly make fire resistant item " + item.getName((ItemStack)null).getString() + " a furnace fuel. That will not work!"));
            }
        } else {
            map.put(item, burnTime);
        }
    }

    private static double getTierMultiplier(String tierId) {
        return switch (tierId) {
            case "compressed" -> (Double)Config.compressedFuelMultiplier.get();
            case "double_compressed" -> (Double)Config.doubleCompressedFuelMultiplier.get();
            case "triple_compressed" -> (Double)Config.tripleCompressedFuelMultiplier.get();
            default -> throw new IllegalStateException("Unexpected value: " + tierId);
        };
    }
}

