/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.screen.powered;

import net.biorfn.compressedfurnace.menu.powered.AbstractCompressedPoweredMenu;
import net.biorfn.compressedfurnace.network.AutoSplitToggleButton;
import net.biorfn.compressedfurnace.network.Messages;
import net.biorfn.compressedfurnace.screen.AbstractCompressedScreen;
import net.biorfn.compressedfurnace.util.GuiEnergy;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public abstract class AbstractCompressedPoweredScreen<T extends AbstractCompressedPoweredMenu>
extends AbstractCompressedScreen<T> {
    private GuiEnergy energyBar;

    public AbstractCompressedPoweredScreen(T menu, Inventory playerInventory, Component title, String teirId, String type) {
        super(menu, playerInventory, title, teirId, "powered_" + type);
    }

    @Override
    protected void init() {
        super.init();
        this.renderAutoSplitButton();
        this.energyBar = new GuiEnergy(this.leftPos, this.topPos, 22, 17, 14, 42);
        this.renderXPButton();
    }

    @Override
    protected void renderAutoSplitButton() {
        int buttonX = this.leftPos + 7;
        int buttonY = this.topPos + 5;
        this.toggleAutoSplit = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"S"), button -> Messages.sendToServer(AutoSplitToggleButton.create())).bounds(buttonX, buttonY, 14, 14).build());
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float v, int mouseX, int mouseY) {
        this.renderBG(guiGraphics);
        this.renderHasXP(guiGraphics);
        this.renderEnergyBar(guiGraphics);
        this.renderProgressBars(guiGraphics);
    }

    protected void renderEnergyBar(GuiGraphics guiGraphics) {
        int energyHeight = this.getScaledEnergyHeight();
        if (energyHeight > 0) {
            switch (this.teirId) {
                case "compressed": {
                    guiGraphics.blit(this.GUI, this.leftPos + 22, this.topPos + 17 + (42 - energyHeight), 176, this.type.equals("powered_crusher") ? 16 : 22, 14, energyHeight);
                    break;
                }
                case "double_compressed": {
                    guiGraphics.blit(this.DOUBLE_GUI, this.leftPos + 22, this.topPos + 17 + (42 - energyHeight), 176, this.type.equals("powered_crusher") ? 16 : 22, 14, energyHeight);
                    break;
                }
                case "triple_compressed": {
                    guiGraphics.blit(this.TRIPLE_GUI, this.leftPos + 22, this.topPos + 17 + (42 - energyHeight), 176, this.type.equals("powered_crusher") ? 16 : 22, 14, energyHeight);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + this.teirId);
                }
            }
        }
    }

    @Override
    protected void renderHasXP(GuiGraphics guiGraphics) {
        int sButtonX = this.leftPos + 22;
        int sButtonY = this.topPos + 62;
        if (((AbstractCompressedPoweredMenu)this.menu).hasXPWaiting()) {
            switch (this.teirId) {
                case "compressed": {
                    guiGraphics.blit(this.GUI, sButtonX, sButtonY, 176, this.type.equals("powered_crusher") ? 59 : 65, 11, 15);
                    break;
                }
                case "double_compressed": {
                    guiGraphics.blit(this.DOUBLE_GUI, sButtonX, sButtonY, 176, this.type.equals("powered_crusher") ? 59 : 65, 11, 15);
                    break;
                }
                case "triple_compressed": {
                    guiGraphics.blit(this.TRIPLE_GUI, sButtonX, sButtonY, 176, this.type.equals("powered_crusher") ? 59 : 65, 11, 15);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + this.teirId);
                }
            }
        }
    }

    protected int getScaledEnergyHeight() {
        int maxEnergy = ((AbstractCompressedPoweredMenu)this.menu).getMaxEnergy();
        int currentEnergy = ((AbstractCompressedPoweredMenu)this.menu).getEnergy();
        if (maxEnergy == 0) {
            return 0;
        }
        return currentEnergy * 42 / maxEnergy;
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        this.energyBar.renderTooltip(this.font, guiGraphics, mouseX, mouseY, ((AbstractCompressedPoweredMenu)this.menu).getEnergy(), ((AbstractCompressedPoweredMenu)this.menu).getMaxEnergy(), true, true);
    }
}

