/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.screen;

import java.util.Map;
import java.util.function.Consumer;
import net.biorfn.compressedfurnace.util.widgets.ConfigSlider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class OpenConfigScreen
extends Screen {
    private Map<String, Integer> temporaryConfig;
    private float scrollAmount = 0.0f;
    private int totalHeight = 0;
    private int visibleHeight;

    protected OpenConfigScreen(Map<String, Integer> configData) {
        super((Component)Component.literal((String)"config_menu"));
        this.temporaryConfig = configData;
        this.visibleHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight();
    }

    protected void init() {
        this.clearWidgets();
        this.visibleHeight = this.height;
        int buttonWidth = 230;
        int buttonHeight = 20;
        int gridColumns = 2;
        int startX = this.width / 2 - gridColumns * (buttonWidth + 10) / 2;
        int startY = 75;
        int backButton = startY + 240;
        this.exitSaveButton(startX, backButton, buttonWidth, buttonHeight, gridColumns);
    }

    private void applyChanges() {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        int xStart = 0;
        int yStart = 0;
        int xEnd = this.width;
        int yEnd = yStart + this.visibleHeight;
        guiGraphics.enableScissor(xStart, yStart, xEnd, yEnd);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, -this.scrollAmount, 0.0f);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.pose().popPose();
        guiGraphics.disableScissor();
    }

    private void exitSaveButton(int startX, int startY, int buttonWidth, int buttonHeight, int gridColumns) {
        this.placeButtonInGridBase(0, startX, startY, buttonWidth, buttonHeight, gridColumns, (Component)Component.literal((String)"Exit"), button -> this.onClose());
        this.placeButtonInGridBase(1, startX, startY, buttonWidth, buttonHeight, gridColumns, (Component)Component.literal((String)"Save"), button -> this.applyChanges());
    }

    private void compressed() {
    }

    private void placeSliderInGridEnergy(int index, int startX, int startY, int buttonWidth, int buttonHeight, int gridColumns, Component label, int initialValue, int minValue, int maxValue, Consumer<Integer> onValueChange) {
        this.placeSliderInGridBase(index, startX, startY, buttonWidth, buttonHeight, gridColumns, label, initialValue, minValue, maxValue, true, onValueChange);
    }

    private void placeSliderInGridBase(int index, int startX, int startY, int buttonWidth, int buttonHeight, int gridColumns, Component label, int initialValue, int minValue, int maxValue, boolean energy, Consumer<Integer> onValueChange) {
        int col = index % gridColumns;
        int row = index / gridColumns;
        int x = startX + col * (buttonWidth + 10);
        int y = startY + row * (buttonHeight + 10);
        this.addRenderableWidget((GuiEventListener)new ConfigSlider(x, y, buttonWidth, buttonHeight, label, initialValue, minValue, maxValue, onValueChange));
    }

    private void placeButtonInGridBase(int index, int startX, int startY, int buttonWidth, int buttonHeight, int gridColumns, Component label, Button.OnPress onPress) {
        int col = index % gridColumns;
        int row = index / gridColumns;
        int x = startX + col * (buttonWidth + 10);
        int y = startY + row * (buttonHeight + 10);
        this.addRenderableWidget((GuiEventListener)new Button.Builder(label, onPress).bounds(x, y, buttonWidth, buttonHeight).build());
    }

    public void onClose() {
        this.temporaryConfig.clear();
        super.onClose();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.totalHeight > this.visibleHeight && scrollY != 0.0) {
            this.scrollAmount += (float)(scrollY * -10.0);
            this.scrollAmount = Math.max(0.0f, Math.min(this.scrollAmount, (float)Math.max(0, this.totalHeight - this.visibleHeight)));
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }
}

