/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.screen;

import java.util.List;
import net.biorfn.compressedfurnace.menu.AbstractCompressedMenu;
import net.biorfn.compressedfurnace.network.AutoSplitToggleButton;
import net.biorfn.compressedfurnace.network.Messages;
import net.biorfn.compressedfurnace.network.XPButton;
import net.biorfn.compressedfurnace.util.CallConstants;
import net.biorfn.compressedfurnace.util.widgets.ClickableArea;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;

public abstract class AbstractCompressedScreen<T extends AbstractCompressedMenu>
extends AbstractContainerScreen<T> {
    public final ResourceLocation GUI;
    public final ResourceLocation DOUBLE_GUI;
    public final ResourceLocation TRIPLE_GUI;
    protected Button toggleAutoSplit;
    public ClickableArea XP_BOTTLE;
    protected final int sButtonWidth = 11;
    protected final int sButtonHeight = 15;
    Inventory playerInv;
    Component name;
    protected String teirId;
    protected String type;

    public AbstractCompressedScreen(T menu, Inventory playerInventory, Component title, String teirId, String type) {
        super(menu, playerInventory, title);
        this.GUI = CallConstants.getLocation("textures/gui/" + this.blockName(type) + "_factory.png");
        this.DOUBLE_GUI = CallConstants.getLocation("textures/gui/" + this.blockName(type) + "_double_factory.png");
        this.TRIPLE_GUI = CallConstants.getLocation("textures/gui/" + this.blockName(type) + "_triple_factory.png");
        this.playerInv = playerInventory;
        this.name = title;
        this.teirId = teirId;
        this.type = type;
    }

    protected void init() {
        super.init();
        this.renderAutoSplitButton();
        this.renderXPButton();
    }

    protected void renderAutoSplitButton() {
        int buttonX = this.leftPos + 9;
        int buttonY = this.topPos + 5;
        this.toggleAutoSplit = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"S"), button -> Messages.sendToServer(AutoSplitToggleButton.create())).bounds(buttonX, buttonY, 14, 14).build());
    }

    protected void renderXPButton() {
        int sButtonX = this.leftPos + 22;
        int sButtonY = this.topPos + 62;
        this.XP_BOTTLE = new ClickableArea(sButtonX, sButtonY, 11, 15, button -> Messages.sendToServer(XPButton.create()));
        this.XP_BOTTLE.active = ((AbstractCompressedMenu)this.menu).hasXPWaiting();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ClientTooltipComponent tooltipComponent1;
        ClientTooltipComponent tooltipComponent0;
        FormattedCharSequence textSequence1;
        FormattedCharSequence textSequence0;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (((AbstractCompressedMenu)this.menu).autoSplitEnabled()) {
            this.toggleAutoSplit.setMessage((Component)Component.literal((String)"S").withStyle(style -> style.withColor(ChatFormatting.GREEN)));
        } else {
            this.toggleAutoSplit.setMessage((Component)Component.literal((String)"S").withStyle(style -> style.withColor(ChatFormatting.DARK_RED)));
        }
        if (this.isMouseOverSplit(this.toggleAutoSplit, mouseX, mouseY)) {
            textSequence0 = Component.literal((String)"Split Inputs").getVisualOrderText();
            textSequence1 = Component.literal((String)"Current State: ").append((Component)Component.literal((String)(((AbstractCompressedMenu)this.menu).autoSplitEnabled() ? "ON" : "OFF"))).getVisualOrderText();
            tooltipComponent0 = ClientTooltipComponent.create((FormattedCharSequence)textSequence0);
            tooltipComponent1 = ClientTooltipComponent.create((FormattedCharSequence)textSequence1);
            guiGraphics.renderTooltip(this.font, List.of(textSequence0, textSequence1), DefaultTooltipPositioner.INSTANCE, mouseX, mouseY);
        }
        this.XP_BOTTLE.active = ((AbstractCompressedMenu)this.menu).hasXPWaiting();
        if (((AbstractCompressedMenu)this.menu).hasXPWaiting() && this.XP_BOTTLE.isMouseOver(mouseX, mouseY)) {
            textSequence0 = Component.literal((String)"XP Available").getVisualOrderText();
            textSequence1 = Component.literal((String)"Click to collect. ").getVisualOrderText();
            tooltipComponent0 = ClientTooltipComponent.create((FormattedCharSequence)textSequence0);
            tooltipComponent1 = ClientTooltipComponent.create((FormattedCharSequence)textSequence1);
            guiGraphics.renderTooltip(this.font, List.of(textSequence0, textSequence1), DefaultTooltipPositioner.INSTANCE, mouseX, mouseY);
        }
    }

    private boolean isMouseOverSplit(Button button, int mouseX, int mouseY) {
        return mouseX >= button.getX() && mouseX <= button.getX() + button.getWidth() && mouseY >= button.getY() && mouseY <= button.getY() + button.getHeight();
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.imageHeight - this.imageHeight - 10, 0x404040);
        guiGraphics.drawString(this.font, this.playerInv.getDisplayName(), this.titleLabelX, -2000, 0x404040);
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int mouseX, int mouseY) {
        this.renderBG(guiGraphics);
        this.renderHasXP(guiGraphics);
        this.renderLitIndicator(guiGraphics);
        this.renderProgressBars(guiGraphics);
    }

    protected void renderBG(GuiGraphics guiGraphics) {
        int left = this.leftPos;
        int top = this.topPos;
        switch (this.teirId) {
            case "compressed": {
                guiGraphics.blit(this.GUI, left, top, 0, 0, this.imageWidth, this.imageHeight);
                break;
            }
            case "double_compressed": {
                guiGraphics.blit(this.DOUBLE_GUI, left, top, 0, 0, this.imageWidth, this.imageHeight);
                break;
            }
            case "triple_compressed": {
                guiGraphics.blit(this.TRIPLE_GUI, left, top, 0, 0, this.imageWidth, this.imageHeight);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected tier: " + this.teirId);
            }
        }
    }

    protected void renderHasXP(GuiGraphics guiGraphics) {
        int sButtonX = this.leftPos + 22;
        int sButtonY = this.topPos + 62;
        if (((AbstractCompressedMenu)this.menu).hasXPWaiting()) {
            switch (this.teirId) {
                case "compressed": {
                    guiGraphics.blit(this.GUI, sButtonX, sButtonY, 176, 38, 11, 15);
                    break;
                }
                case "double_compressed": {
                    guiGraphics.blit(this.DOUBLE_GUI, sButtonX, sButtonY, 176, 38, 11, 15);
                    break;
                }
                case "triple_compressed": {
                    guiGraphics.blit(this.TRIPLE_GUI, sButtonX, sButtonY, 176, 38, 11, 15);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + this.teirId);
                }
            }
        }
    }

    protected void renderLitIndicator(GuiGraphics guiGraphics) {
        if (((AbstractCompressedMenu)this.menu).isLit()) {
            int litHeight = (int)(((AbstractCompressedMenu)this.menu).getLitProgress() * 13.0f);
            int litYOffset = 13 - litHeight;
            switch (this.teirId) {
                case "compressed": {
                    guiGraphics.blit(this.GUI, this.leftPos + 10, this.topPos + 20 + litYOffset, 176, 23 + litYOffset, 14, litHeight);
                    break;
                }
                case "double_compressed": {
                    guiGraphics.blit(this.DOUBLE_GUI, this.leftPos + 10, this.topPos + 20 + litYOffset, 176, 23 + litYOffset, 14, litHeight);
                    break;
                }
                case "triple_compressed": {
                    guiGraphics.blit(this.TRIPLE_GUI, this.leftPos + 10, this.topPos + 20 + litYOffset, 176, 23 + litYOffset, 14, litHeight);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected tier: " + this.teirId);
                }
            }
        }
    }

    protected void renderProgressBars(GuiGraphics guiGraphics) {
        int baseX = this.getXStart(this.teirId);
        int baseY = this.type.equals("crusher") || this.type.equals("powered_crusher") ? 30 : 27;
        int slotOffsetX = 21;
        int[] slotIndices = ((AbstractCompressedMenu)this.menu).SlotForInput(this.teirId);
        block10: for (int i = 0; i < slotIndices.length; ++i) {
            int xPosition = this.leftPos + baseX + i * slotOffsetX;
            int yPosition = this.topPos + baseY;
            int progress = ((AbstractCompressedMenu)this.menu).getProgressForSlot(2 + i * 2);
            int maxProgress = ((AbstractCompressedMenu)this.menu).getMaxProgressForSlot(3 + i * 2);
            float progressRatio = maxProgress == 0 ? 0.0f : (float)progress / (float)maxProgress;
            int maxHeight = this.type.equals("crusher") || this.type.equals("powered_crusher") ? 16 : 24;
            int baseWidth = this.type.equals("crusher") || this.type.equals("powered_crusher") ? 18 : 16;
            int scaledHeight = (int)(progressRatio * (float)maxHeight);
            switch (this.teirId) {
                case "compressed": {
                    guiGraphics.blit(this.GUI, xPosition, yPosition, 176, 0, baseWidth, scaledHeight);
                    continue block10;
                }
                case "double_compressed": {
                    guiGraphics.blit(this.DOUBLE_GUI, xPosition, yPosition, 176, 0, baseWidth, scaledHeight);
                    continue block10;
                }
                case "triple_compressed": {
                    guiGraphics.blit(this.TRIPLE_GUI, xPosition, yPosition, 176, 0, baseWidth, scaledHeight);
                    continue block10;
                }
                default: {
                    throw new IllegalStateException("Unexpected tier: " + this.teirId);
                }
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (((AbstractCompressedMenu)this.menu).hasXPWaiting()) {
            this.XP_BOTTLE.mouseClicked((int)mouseX, (int)mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void slotClicked(Slot slot, int slotId, int mouseButton, ClickType type) {
        super.slotClicked(slot, slotId, mouseButton, type);
    }

    protected int getXStart(String tierID) {
        return switch (tierID) {
            case "compressed" -> {
                if (this.type.equals("crusher") || this.type.equals("powered_crusher")) {
                    yield 69;
                }
                yield 71;
            }
            case "double_compressed" -> {
                if (this.type.equals("crusher") || this.type.equals("powered_crusher")) {
                    yield 63;
                }
                yield 65;
            }
            case "triple_compressed" -> {
                if (this.type.equals("crusher") || this.type.equals("powered_crusher")) {
                    yield 42;
                }
                yield 44;
            }
            default -> throw new IllegalStateException("Unexpected value: " + tierID);
        };
    }

    protected String blockName(String type) {
        return type.equals("blast") ? "furnace" : (type.equals("powered_blast") ? "powered_furnace" : type);
    }
}

