/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.menu;

import net.biorfn.compressedfurnace.entity.AbstractCompressedEntityBlock;
import net.biorfn.compressedfurnace.menu.slots.FuelSlot;
import net.biorfn.compressedfurnace.menu.slots.ResultSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AbstractCompressedMenu
extends AbstractContainerMenu {
    public final int FUEL = 0;
    public final int INPUT0 = 1;
    public final int OUTPUT0 = 2;
    public final int INPUT1 = 3;
    public final int OUTPUT1 = 4;
    public final int INPUT2 = 5;
    public final int OUTPUT2 = 6;
    public final int INPUT3 = 7;
    public final int OUTPUT3 = 8;
    public final int INPUT4 = 9;
    public final int OUTPUT4 = 10;
    public final int INPUT5 = 11;
    public final int OUTPUT5 = 12;
    protected Container container;
    protected final ContainerData data;
    protected final ContainerData data1;
    protected final Level level;
    protected final RecipeType<? extends AbstractCookingRecipe> recipeType;
    protected String tierID;

    public AbstractCompressedMenu(MenuType<?> menuType, int windowId, Level level, Inventory playerInventory, String tierID, RecipeType<? extends AbstractCookingRecipe> recipeType) {
        this(menuType, windowId, level, playerInventory, tierID, (ContainerData)new SimpleContainerData(14), (ContainerData)new SimpleContainerData(8), recipeType);
    }

    public AbstractCompressedMenu(MenuType<?> menuType, int windowId, Level level, Inventory playerInventory, String tierID, ContainerData data, ContainerData data1, RecipeType<? extends AbstractCookingRecipe> recipeType) {
        super(menuType, windowId);
        Player player = playerInventory.player;
        BlockHitResult blockHitResult = (BlockHitResult)player.pick(5.0, 0.0f, false);
        BlockPos pos = blockHitResult.getBlockPos();
        if (!(level.getBlockEntity(pos) instanceof AbstractCompressedEntityBlock)) {
            throw new IllegalStateException("Container provider is not a AbstractCompressedEntityBlock in AbstractCompressedMenu");
        }
        this.container = (AbstractCompressedEntityBlock)level.getBlockEntity(pos);
        this.data = data;
        this.data1 = data1;
        this.level = playerInventory.player.level();
        this.tierID = tierID;
        this.recipeType = recipeType;
        this.addTierSpecificSlots(this.container, playerInventory, tierID);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
        this.addDataSlots(data);
        this.addDataSlots(data1);
    }

    public AbstractCompressedEntityBlock getBlockEntity() {
        return (AbstractCompressedEntityBlock)this.container;
    }

    public boolean autoSplitEnabled() {
        return this.data1.get(0) == 1;
    }

    public boolean hasXPWaiting() {
        return this.data1.get(1) > 0;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    protected boolean canSmelt(ItemStack itemStack) {
        return this.level.getRecipeManager().getRecipeFor(this.recipeType, (RecipeInput)new SingleRecipeInput(itemStack), this.level).isPresent();
    }

    protected boolean isFuel(ItemStack stack) {
        return stack.getBurnTime(this.recipeType) > 0;
    }

    public int getProgressForSlot(int index) {
        return this.data.get(index);
    }

    public int getMaxProgressForSlot(int index) {
        return this.data.get(index);
    }

    public float getLitProgress() {
        int i = this.data.get(1);
        if (i == 0) {
            i = 200;
        }
        return Mth.clamp((float)((float)this.data.get(0) / (float)i), (float)0.0f, (float)1.0f);
    }

    public boolean isLit() {
        return this.data.get(0) > 0;
    }

    protected void addTierSpecificSlots(Container container, Inventory playerInventory, String tierID) {
        if (tierID != null) {
            switch (tierID) {
                case "compressed": {
                    this.addSlot(new FuelSlot(container, 0, 9, 37));
                    this.addSlot(new Slot(container, 1, 70, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 2, 70, 55));
                    this.addSlot(new Slot(container, 3, 91, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 4, 91, 55));
                    break;
                }
                case "double_compressed": {
                    this.addSlot(new FuelSlot(container, 0, 9, 37));
                    this.addSlot(new Slot(container, 1, 64, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 2, 64, 55));
                    this.addSlot(new Slot(container, 3, 85, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 4, 85, 55));
                    this.addSlot(new Slot(container, 5, 106, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 6, 106, 55));
                    this.addSlot(new Slot(container, 7, 127, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 8, 127, 55));
                    break;
                }
                case "triple_compressed": {
                    this.addSlot(new FuelSlot(container, 0, 9, 37));
                    this.addSlot(new Slot(container, 1, 43, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 2, 43, 55));
                    this.addSlot(new Slot(container, 3, 64, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 4, 64, 55));
                    this.addSlot(new Slot(container, 5, 85, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 6, 85, 55));
                    this.addSlot(new Slot(container, 7, 106, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 8, 106, 55));
                    this.addSlot(new Slot(container, 9, 127, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 10, 127, 55));
                    this.addSlot(new Slot(container, 11, 148, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 12, 148, 55));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected tier: " + tierID);
                }
            }
        }
    }

    public int[] SlotForInput(String tierID) {
        int[] nArray;
        switch (tierID) {
            case "compressed": {
                int[] nArray2 = new int[2];
                nArray2[0] = 1;
                nArray = nArray2;
                nArray2[1] = 3;
                break;
            }
            case "double_compressed": {
                int[] nArray3 = new int[4];
                nArray3[0] = 1;
                nArray3[1] = 3;
                nArray3[2] = 5;
                nArray = nArray3;
                nArray3[3] = 7;
                break;
            }
            case "triple_compressed": {
                int[] nArray4 = new int[6];
                nArray4[0] = 1;
                nArray4[1] = 3;
                nArray4[2] = 5;
                nArray4[3] = 7;
                nArray4[4] = 9;
                nArray = nArray4;
                nArray4[5] = 11;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + tierID);
            }
        }
        return nArray;
    }
}

