/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.biorfn.compressedfurnace.jei.RecipeCategoryGenerator;
import net.biorfn.compressedfurnace.jei.RecipeCatigoryCrusher;
import net.biorfn.compressedfurnace.menu.blast.CompressedBlastFurnaceMenu;
import net.biorfn.compressedfurnace.menu.blast.DoubleCompressedBlastFurnaceMenu;
import net.biorfn.compressedfurnace.menu.blast.TripleCompressedBlastFurnaceMenu;
import net.biorfn.compressedfurnace.menu.crusher.CompressedCrusherMenu;
import net.biorfn.compressedfurnace.menu.crusher.DoubleCrusherMenu;
import net.biorfn.compressedfurnace.menu.crusher.TripleCrusherMenu;
import net.biorfn.compressedfurnace.menu.furnace.CompressedFurnaceMenu;
import net.biorfn.compressedfurnace.menu.furnace.DoubleCompressedFurnaceMenu;
import net.biorfn.compressedfurnace.menu.furnace.TripleCompressedFurnaceMenu;
import net.biorfn.compressedfurnace.menu.generator.CompressedGeneratorMenu;
import net.biorfn.compressedfurnace.menu.generator.DoubleCompressedGeneratorMenu;
import net.biorfn.compressedfurnace.menu.generator.TripleCompressedGeneratorMenu;
import net.biorfn.compressedfurnace.menu.powered.blast.PoweredCompressedBlastFurnaceMenu;
import net.biorfn.compressedfurnace.menu.powered.blast.PoweredDoubleCompressedBlastFurnaceMenu;
import net.biorfn.compressedfurnace.menu.powered.blast.PoweredTripleCompressedBlastFurnaceMenu;
import net.biorfn.compressedfurnace.menu.powered.crusher.PoweredCompressedCrusherMenu;
import net.biorfn.compressedfurnace.menu.powered.crusher.PoweredDoubleCompressedCrusherMenu;
import net.biorfn.compressedfurnace.menu.powered.crusher.PoweredTripleCompressedCrusherMenu;
import net.biorfn.compressedfurnace.menu.powered.furnace.PoweredCompressedFurnaceMenu;
import net.biorfn.compressedfurnace.menu.powered.furnace.PoweredDoubleCompressedFurnaceMenu;
import net.biorfn.compressedfurnace.menu.powered.furnace.PoweredTripleCompressedFurnaceMenu;
import net.biorfn.compressedfurnace.recipes.CrusherRecipe;
import net.biorfn.compressedfurnace.recipes.GeneratorRecipe;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.biorfn.compressedfurnace.screen.blast.CompressedBlastFurnaceScreen;
import net.biorfn.compressedfurnace.screen.blast.DoubleCompressedBlastFurnaceScreen;
import net.biorfn.compressedfurnace.screen.blast.TripleCompressedBlastFurnaceScreen;
import net.biorfn.compressedfurnace.screen.crusher.CompressedCrusherScreen;
import net.biorfn.compressedfurnace.screen.crusher.DoubleCrusherScreen;
import net.biorfn.compressedfurnace.screen.crusher.TripleCrusherScreen;
import net.biorfn.compressedfurnace.screen.furnace.CompressedFurnaceScreen;
import net.biorfn.compressedfurnace.screen.furnace.DoubleCompressedFurnaceScreen;
import net.biorfn.compressedfurnace.screen.furnace.TripleCompressedFurnaceScreen;
import net.biorfn.compressedfurnace.screen.generator.CompressedGeneratorScreen;
import net.biorfn.compressedfurnace.screen.generator.DoubleCompressedGeneratorScreen;
import net.biorfn.compressedfurnace.screen.generator.TripleCompressedGeneratorScreen;
import net.biorfn.compressedfurnace.screen.powered.blast.PoweredCompressedBlastFurnaceScreen;
import net.biorfn.compressedfurnace.screen.powered.blast.PoweredDoubleCompressedBlastFurnaceScreen;
import net.biorfn.compressedfurnace.screen.powered.blast.PoweredTripleCompressedBlastFurnaceScreen;
import net.biorfn.compressedfurnace.screen.powered.crusher.PoweredCompressedCrusherScreen;
import net.biorfn.compressedfurnace.screen.powered.crusher.PoweredDoubleCompressedCrusherScreen;
import net.biorfn.compressedfurnace.screen.powered.crusher.PoweredTripleCompressedCrusherScreen;
import net.biorfn.compressedfurnace.screen.powered.furnace.PoweredCompressedFurnaceScreen;
import net.biorfn.compressedfurnace.screen.powered.furnace.PoweredDoubleCompressedFurnaceScreen;
import net.biorfn.compressedfurnace.screen.powered.furnace.PoweredTripleCompressedFurnaceScreen;
import net.biorfn.compressedfurnace.util.CallConstants;
import net.biorfn.compressedfurnace.util.entitiy.FuelManager;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class MultiFurnaceJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return CallConstants.getLocation("plugin_compressedfurnace");
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new RecipeCatigoryCrusher(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RecipeCategoryGenerator(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<GeneratorRecipe> genRecipes = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)MultiFurnaceTieredItems.GENERATOR_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).toList();
        List<ItemStack> vanillaFuels = registration.getIngredientManager().getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK).stream().filter(stack -> FuelManager.getFuel().containsKey(stack.getItem())).toList();
        List<GeneratorRecipe> fuelRecipes = vanillaFuels.stream().map(stack -> new GeneratorRecipe(FuelManager.getFuel().get(stack.getItem()), Ingredient.of((ItemStack[])new ItemStack[]{stack}))).toList();
        ArrayList<GeneratorRecipe> allRecipes = new ArrayList<GeneratorRecipe>(genRecipes);
        allRecipes.addAll(fuelRecipes);
        List<CrusherRecipe> CrushRecipes = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)MultiFurnaceTieredItems.CRUSHER_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(MultiFurnaceTieredItems.RecipeTypes.GENERATOR_RECIPE_JEI, allRecipes);
        registration.addRecipes(MultiFurnaceTieredItems.RecipeTypes.CRUSHER_RECIPE_JEI, CrushRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.addGenCatalyst(registration, (ItemLike)MultiFurnaceTieredItems.COMPRESSED_GENERATOR.get());
        this.addGenCatalyst(registration, (ItemLike)MultiFurnaceTieredItems.DOUBLE_COMPRESSED_GENERATOR.get());
        this.addGenCatalyst(registration, (ItemLike)MultiFurnaceTieredItems.TRIPLE_COMPRESSED_GENERATOR.get());
        this.addSmeltingCatalyst(registration, (ItemLike)MultiFurnaceTieredItems.COMPRESSED_FURNACE.get(), false);
        this.addSmeltingCatalyst(registration, (ItemLike)MultiFurnaceTieredItems.DOUBLE_COMPRESSED_FURNACE.get(), false);
        this.addSmeltingCatalyst(registration, (ItemLike)MultiFurnaceTieredItems.TRIPLE_COMPRESSED_FURNACE.get(), false);
        this.addSmeltingCatalyst(registration, (ItemLike)MultiFurnaceTieredItems.POWERED_COMPRESSED_FURNACE.get(), true);
        this.addSmeltingCatalyst(registration, (ItemLike)MultiFurnaceTieredItems.POWERED_DOUBLE_COMPRESSED_FURNACE.get(), true);
        this.addSmeltingCatalyst(registration, (ItemLike)MultiFurnaceTieredItems.POWERED_TRIPLE_COMPRESSED_FURNACE.get(), true);
        this.addCrushingCatalyst(registration, (ItemLike)MultiFurnaceTieredItems.COMPRESSED_CRUSHER.get(), false);
        this.addCrushingCatalyst(registration, (ItemLike)MultiFurnaceTieredItems.DOUBLE_COMPRESSED_CRUSHER.get(), false);
        this.addCrushingCatalyst(registration, (ItemLike)MultiFurnaceTieredItems.TRIPLE_COMPRESSED_CRUSHER.get(), false);
        this.addCrushingCatalyst(registration, (ItemLike)MultiFurnaceTieredItems.POWERED_COMPRESSED_CRUSHER.get(), true);
        this.addCrushingCatalyst(registration, (ItemLike)MultiFurnaceTieredItems.POWERED_DOUBLE_COMPRESSED_CRUSHER.get(), true);
        this.addCrushingCatalyst(registration, (ItemLike)MultiFurnaceTieredItems.POWERED_TRIPLE_COMPRESSED_CRUSHER.get(), true);
        this.addBlastingCatalyst(registration, (ItemLike)MultiFurnaceTieredItems.COMPRESSED_BLAST_FURNACE.get(), false);
        this.addBlastingCatalyst(registration, (ItemLike)MultiFurnaceTieredItems.DOUBLE_COMPRESSED_BLAST_FURNACE.get(), false);
        this.addBlastingCatalyst(registration, (ItemLike)MultiFurnaceTieredItems.TRIPLE_COMPRESSED_BLAST_FURNACE.get(), false);
        this.addBlastingCatalyst(registration, (ItemLike)MultiFurnaceTieredItems.POWERED_COMPRESSED_BLAST_FURNACE.get(), true);
        this.addBlastingCatalyst(registration, (ItemLike)MultiFurnaceTieredItems.POWERED_DOUBLE_COMPRESSED_BLAST_FURNACE.get(), true);
        this.addBlastingCatalyst(registration, (ItemLike)MultiFurnaceTieredItems.POWERED_TRIPLE_COMPRESSED_BLAST_FURNACE.get(), true);
    }

    private void addGenCatalyst(IRecipeCatalystRegistration registration, ItemLike itemLike) {
        registration.addRecipeCatalyst(new ItemStack(itemLike), new RecipeType[]{MultiFurnaceTieredItems.RecipeTypes.GENERATOR_RECIPE_JEI});
    }

    private void addSmeltingCatalyst(IRecipeCatalystRegistration registration, ItemLike itemLike, boolean powered) {
        if (powered) {
            registration.addRecipeCatalyst(new ItemStack(itemLike), new RecipeType[]{RecipeTypes.SMELTING});
        } else {
            registration.addRecipeCatalyst(new ItemStack(itemLike), new RecipeType[]{RecipeTypes.SMELTING});
            registration.addRecipeCatalyst(new ItemStack(itemLike), new RecipeType[]{RecipeTypes.FUELING});
        }
    }

    private void addBlastingCatalyst(IRecipeCatalystRegistration registration, ItemLike itemLike, boolean powered) {
        if (powered) {
            registration.addRecipeCatalyst(new ItemStack(itemLike), new RecipeType[]{RecipeTypes.BLASTING});
        } else {
            registration.addRecipeCatalyst(new ItemStack(itemLike), new RecipeType[]{RecipeTypes.BLASTING});
            registration.addRecipeCatalyst(new ItemStack(itemLike), new RecipeType[]{RecipeTypes.FUELING});
        }
    }

    private void addCrushingCatalyst(IRecipeCatalystRegistration registration, ItemLike itemLike, boolean powered) {
        if (powered) {
            registration.addRecipeCatalyst(new ItemStack(itemLike), new RecipeType[]{MultiFurnaceTieredItems.RecipeTypes.CRUSHER_RECIPE_JEI});
        } else {
            registration.addRecipeCatalyst(new ItemStack(itemLike), new RecipeType[]{MultiFurnaceTieredItems.RecipeTypes.CRUSHER_RECIPE_JEI});
            registration.addRecipeCatalyst(new ItemStack(itemLike), new RecipeType[]{RecipeTypes.FUELING});
        }
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        this.addGenHandler(registration, CompressedGeneratorMenu.class, MultiFurnaceTieredItems.COMPRESSED_GENERATOR_MENU.get());
        this.addGenHandler(registration, DoubleCompressedGeneratorMenu.class, MultiFurnaceTieredItems.DOUBLE_COMPRESSED_GENERATOR_MENU.get());
        this.addGenHandler(registration, TripleCompressedGeneratorMenu.class, MultiFurnaceTieredItems.TRIPLE_COMPRESSED_GENERATOR_MENU.get());
        this.addFurnaceHandler(registration);
        this.addCrusherHandler(registration);
    }

    <C extends AbstractContainerMenu, R> void addGenHandler(IRecipeTransferRegistration registration, Class<? extends C> containerClass, @Nullable MenuType<C> menuType) {
        registration.addRecipeTransferHandler(containerClass, menuType, RecipeTypes.FUELING, 0, 1, 1, 36);
        registration.addRecipeTransferHandler(containerClass, menuType, MultiFurnaceTieredItems.RecipeTypes.GENERATOR_RECIPE_JEI, 0, 1, 1, 36);
    }

    <C extends AbstractContainerMenu, R> void addFurnaceHandler(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(CompressedFurnaceMenu.class, MultiFurnaceTieredItems.COMPRESSED_FURNACE_MENU.get(), RecipeTypes.FUELING, 0, 1, 5, 36);
        registration.addRecipeTransferHandler(CompressedFurnaceMenu.class, MultiFurnaceTieredItems.COMPRESSED_FURNACE_MENU.get(), RecipeTypes.SMELTING, 3, 1, 5, 36);
        registration.addRecipeTransferHandler(DoubleCompressedFurnaceMenu.class, MultiFurnaceTieredItems.DOUBLE_COMPRESSED_FURNACE_MENU.get(), RecipeTypes.FUELING, 0, 1, 9, 36);
        registration.addRecipeTransferHandler(DoubleCompressedFurnaceMenu.class, MultiFurnaceTieredItems.DOUBLE_COMPRESSED_FURNACE_MENU.get(), RecipeTypes.SMELTING, 7, 1, 9, 36);
        registration.addRecipeTransferHandler(TripleCompressedFurnaceMenu.class, MultiFurnaceTieredItems.TRIPLE_COMPRESSED_FURNACE_MENU.get(), RecipeTypes.FUELING, 0, 1, 13, 36);
        registration.addRecipeTransferHandler(TripleCompressedFurnaceMenu.class, MultiFurnaceTieredItems.TRIPLE_COMPRESSED_FURNACE_MENU.get(), RecipeTypes.SMELTING, 11, 1, 13, 36);
        registration.addRecipeTransferHandler(PoweredCompressedFurnaceMenu.class, MultiFurnaceTieredItems.POWERED_COMPRESSED_FURNACE_MENU.get(), RecipeTypes.SMELTING, 2, 1, 4, 36);
        registration.addRecipeTransferHandler(PoweredDoubleCompressedFurnaceMenu.class, MultiFurnaceTieredItems.POWERED_DOUBLE_COMMPRESSED_FURNACE_MENU.get(), RecipeTypes.SMELTING, 6, 1, 8, 36);
        registration.addRecipeTransferHandler(PoweredTripleCompressedFurnaceMenu.class, MultiFurnaceTieredItems.POWERED_TRIPLE_COMPRESSED_FURNACE_MENU.get(), RecipeTypes.SMELTING, 10, 1, 12, 36);
    }

    <C extends AbstractContainerMenu, R> void addBlastFurnaceHandler(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(CompressedBlastFurnaceMenu.class, MultiFurnaceTieredItems.COMPRESSED_BLAST_FURNACE_MENU.get(), RecipeTypes.FUELING, 0, 1, 5, 36);
        registration.addRecipeTransferHandler(CompressedBlastFurnaceMenu.class, MultiFurnaceTieredItems.COMPRESSED_BLAST_FURNACE_MENU.get(), RecipeTypes.BLASTING, 3, 1, 5, 36);
        registration.addRecipeTransferHandler(DoubleCompressedBlastFurnaceMenu.class, MultiFurnaceTieredItems.DOUBLE_COMPRESSED_BLAST_FURNACE_MENU.get(), RecipeTypes.FUELING, 0, 1, 9, 36);
        registration.addRecipeTransferHandler(DoubleCompressedBlastFurnaceMenu.class, MultiFurnaceTieredItems.DOUBLE_COMPRESSED_BLAST_FURNACE_MENU.get(), RecipeTypes.BLASTING, 7, 1, 9, 36);
        registration.addRecipeTransferHandler(TripleCompressedBlastFurnaceMenu.class, MultiFurnaceTieredItems.TRIPLE_COMPRESSED_BLAST_FURNACE_MENU.get(), RecipeTypes.FUELING, 0, 1, 13, 36);
        registration.addRecipeTransferHandler(TripleCompressedBlastFurnaceMenu.class, MultiFurnaceTieredItems.TRIPLE_COMPRESSED_BLAST_FURNACE_MENU.get(), RecipeTypes.BLASTING, 11, 1, 13, 36);
        registration.addRecipeTransferHandler(PoweredCompressedBlastFurnaceMenu.class, MultiFurnaceTieredItems.POWERED_COMPRESSED_BLAST_FURNACE_MENU.get(), RecipeTypes.BLASTING, 2, 1, 4, 36);
        registration.addRecipeTransferHandler(PoweredDoubleCompressedBlastFurnaceMenu.class, MultiFurnaceTieredItems.POWERED_DOUBLE_COMPRESSED_BLAST_FURNACE_MENU.get(), RecipeTypes.BLASTING, 6, 1, 8, 36);
        registration.addRecipeTransferHandler(PoweredTripleCompressedBlastFurnaceMenu.class, MultiFurnaceTieredItems.POWERED_TRIPLE_COMPRESSED_BLAST_FURNACE_MENU.get(), RecipeTypes.BLASTING, 10, 1, 12, 36);
    }

    <C extends AbstractContainerMenu, R> void addCrusherHandler(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(CompressedCrusherMenu.class, MultiFurnaceTieredItems.COMPRESSED_CRUSHER_MENU.get(), RecipeTypes.FUELING, 0, 1, 5, 36);
        registration.addRecipeTransferHandler(CompressedCrusherMenu.class, MultiFurnaceTieredItems.COMPRESSED_CRUSHER_MENU.get(), MultiFurnaceTieredItems.RecipeTypes.CRUSHER_RECIPE_JEI, 3, 1, 5, 36);
        registration.addRecipeTransferHandler(DoubleCrusherMenu.class, MultiFurnaceTieredItems.DOUBLE_COMPRESSED_CRUSHER_MENU.get(), RecipeTypes.FUELING, 0, 1, 9, 36);
        registration.addRecipeTransferHandler(DoubleCrusherMenu.class, MultiFurnaceTieredItems.DOUBLE_COMPRESSED_CRUSHER_MENU.get(), MultiFurnaceTieredItems.RecipeTypes.CRUSHER_RECIPE_JEI, 7, 1, 9, 36);
        registration.addRecipeTransferHandler(TripleCrusherMenu.class, MultiFurnaceTieredItems.TRIPLE_COMPRESSED_CRUSHER_MENU.get(), RecipeTypes.FUELING, 0, 1, 13, 36);
        registration.addRecipeTransferHandler(TripleCrusherMenu.class, MultiFurnaceTieredItems.TRIPLE_COMPRESSED_CRUSHER_MENU.get(), MultiFurnaceTieredItems.RecipeTypes.CRUSHER_RECIPE_JEI, 11, 1, 13, 36);
        registration.addRecipeTransferHandler(PoweredCompressedCrusherMenu.class, MultiFurnaceTieredItems.POWERED_COMPRESSED_CRUSHER_MENU.get(), MultiFurnaceTieredItems.RecipeTypes.CRUSHER_RECIPE_JEI, 2, 1, 4, 36);
        registration.addRecipeTransferHandler(PoweredDoubleCompressedCrusherMenu.class, MultiFurnaceTieredItems.POWERED_DOUBLE_COMPRESSED_CRUSHER_MENU.get(), MultiFurnaceTieredItems.RecipeTypes.CRUSHER_RECIPE_JEI, 6, 1, 8, 36);
        registration.addRecipeTransferHandler(PoweredTripleCompressedCrusherMenu.class, MultiFurnaceTieredItems.POWERED_TRIPLE_COMPRESSED_CRUSHER_MENU.get(), MultiFurnaceTieredItems.RecipeTypes.CRUSHER_RECIPE_JEI, 10, 1, 12, 36);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(CompressedFurnaceScreen.class, 69, 27, 40, 24, new RecipeType[]{RecipeTypes.SMELTING});
        registration.addRecipeClickArea(CompressedBlastFurnaceScreen.class, 69, 27, 40, 24, new RecipeType[]{RecipeTypes.BLASTING});
        registration.addRecipeClickArea(CompressedCrusherScreen.class, 69, 27, 40, 24, new RecipeType[]{MultiFurnaceTieredItems.RecipeTypes.CRUSHER_RECIPE_JEI});
        registration.addRecipeClickArea(DoubleCompressedFurnaceScreen.class, 63, 27, 84, 24, new RecipeType[]{RecipeTypes.SMELTING});
        registration.addRecipeClickArea(DoubleCompressedBlastFurnaceScreen.class, 63, 27, 84, 24, new RecipeType[]{RecipeTypes.BLASTING});
        registration.addRecipeClickArea(DoubleCrusherScreen.class, 63, 27, 84, 24, new RecipeType[]{MultiFurnaceTieredItems.RecipeTypes.CRUSHER_RECIPE_JEI});
        registration.addRecipeClickArea(TripleCompressedFurnaceScreen.class, 42, 27, 123, 24, new RecipeType[]{RecipeTypes.SMELTING});
        registration.addRecipeClickArea(TripleCompressedBlastFurnaceScreen.class, 42, 27, 123, 24, new RecipeType[]{RecipeTypes.BLASTING});
        registration.addRecipeClickArea(TripleCrusherScreen.class, 42, 27, 123, 24, new RecipeType[]{MultiFurnaceTieredItems.RecipeTypes.CRUSHER_RECIPE_JEI});
        registration.addRecipeClickArea(PoweredCompressedFurnaceScreen.class, 69, 27, 40, 24, new RecipeType[]{RecipeTypes.SMELTING});
        registration.addRecipeClickArea(PoweredCompressedBlastFurnaceScreen.class, 69, 27, 40, 24, new RecipeType[]{RecipeTypes.BLASTING});
        registration.addRecipeClickArea(PoweredCompressedCrusherScreen.class, 69, 27, 40, 24, new RecipeType[]{MultiFurnaceTieredItems.RecipeTypes.CRUSHER_RECIPE_JEI});
        registration.addRecipeClickArea(PoweredDoubleCompressedFurnaceScreen.class, 63, 27, 84, 24, new RecipeType[]{RecipeTypes.SMELTING});
        registration.addRecipeClickArea(PoweredDoubleCompressedBlastFurnaceScreen.class, 63, 27, 84, 24, new RecipeType[]{RecipeTypes.BLASTING});
        registration.addRecipeClickArea(PoweredDoubleCompressedCrusherScreen.class, 63, 27, 84, 24, new RecipeType[]{MultiFurnaceTieredItems.RecipeTypes.CRUSHER_RECIPE_JEI});
        registration.addRecipeClickArea(PoweredTripleCompressedFurnaceScreen.class, 42, 27, 123, 24, new RecipeType[]{RecipeTypes.SMELTING});
        registration.addRecipeClickArea(PoweredTripleCompressedBlastFurnaceScreen.class, 42, 27, 123, 24, new RecipeType[]{RecipeTypes.BLASTING});
        registration.addRecipeClickArea(PoweredTripleCompressedCrusherScreen.class, 42, 27, 123, 24, new RecipeType[]{MultiFurnaceTieredItems.RecipeTypes.CRUSHER_RECIPE_JEI});
        registration.addRecipeClickArea(CompressedGeneratorScreen.class, 86, 34, 24, 17, new RecipeType[]{MultiFurnaceTieredItems.RecipeTypes.GENERATOR_RECIPE_JEI});
        registration.addRecipeClickArea(DoubleCompressedGeneratorScreen.class, 86, 34, 24, 17, new RecipeType[]{MultiFurnaceTieredItems.RecipeTypes.GENERATOR_RECIPE_JEI});
        registration.addRecipeClickArea(TripleCompressedGeneratorScreen.class, 86, 34, 24, 17, new RecipeType[]{MultiFurnaceTieredItems.RecipeTypes.GENERATOR_RECIPE_JEI});
    }
}

