/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.data;

import net.biorfn.compressedfurnace.blocks.AbstractCompressedBlock;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class MultiFurnaceBlackStateProvider
extends BlockStateProvider {
    private static final String TIER = "compressed";
    private static final String TIER1 = "double_compressed";
    private static final String TIER2 = "triple_compressed";
    private static final String FURNACE = "furnace";
    private static final String BLAST_FURNACE = "blast_furnace";
    private static final String CRUSHER = "crusher";
    private static final String GENERATOR = "generator";
    private static final String POWERED_FURNACE = "powered_furnace";
    private static final String POWERED_BLAST_FURNACE = "powered_blast_furnace";
    private static final String POWERED_CRUSHER = "powered_crusher";

    public MultiFurnaceBlackStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "compressedfurnace", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.customFurnaceLike(MultiFurnaceTieredItems.COMPRESSED_FURNACE, FURNACE, TIER);
        this.customFurnaceLike(MultiFurnaceTieredItems.DOUBLE_COMPRESSED_FURNACE, FURNACE, TIER1);
        this.customFurnaceLike(MultiFurnaceTieredItems.TRIPLE_COMPRESSED_FURNACE, FURNACE, TIER2);
        this.customFurnaceLike(MultiFurnaceTieredItems.COMPRESSED_CRUSHER, CRUSHER, TIER);
        this.customFurnaceLike(MultiFurnaceTieredItems.DOUBLE_COMPRESSED_CRUSHER, CRUSHER, TIER1);
        this.customFurnaceLike(MultiFurnaceTieredItems.TRIPLE_COMPRESSED_CRUSHER, CRUSHER, TIER2);
        this.customFurnaceLike(MultiFurnaceTieredItems.COMPRESSED_GENERATOR, GENERATOR, TIER);
        this.customFurnaceLike(MultiFurnaceTieredItems.DOUBLE_COMPRESSED_GENERATOR, GENERATOR, TIER1);
        this.customFurnaceLike(MultiFurnaceTieredItems.TRIPLE_COMPRESSED_GENERATOR, GENERATOR, TIER2);
        this.customFurnaceLike(MultiFurnaceTieredItems.POWERED_COMPRESSED_FURNACE, POWERED_FURNACE, TIER);
        this.customFurnaceLike(MultiFurnaceTieredItems.POWERED_DOUBLE_COMPRESSED_FURNACE, POWERED_FURNACE, TIER1);
        this.customFurnaceLike(MultiFurnaceTieredItems.POWERED_TRIPLE_COMPRESSED_FURNACE, POWERED_FURNACE, TIER2);
        this.customFurnaceLike(MultiFurnaceTieredItems.POWERED_COMPRESSED_CRUSHER, POWERED_CRUSHER, TIER);
        this.customFurnaceLike(MultiFurnaceTieredItems.POWERED_DOUBLE_COMPRESSED_CRUSHER, POWERED_CRUSHER, TIER1);
        this.customFurnaceLike(MultiFurnaceTieredItems.POWERED_TRIPLE_COMPRESSED_CRUSHER, POWERED_CRUSHER, TIER2);
        this.customBlastFurnaceLike(MultiFurnaceTieredItems.COMPRESSED_BLAST_FURNACE, BLAST_FURNACE, TIER);
        this.customBlastFurnaceLike(MultiFurnaceTieredItems.DOUBLE_COMPRESSED_BLAST_FURNACE, BLAST_FURNACE, TIER1);
        this.customBlastFurnaceLike(MultiFurnaceTieredItems.TRIPLE_COMPRESSED_BLAST_FURNACE, BLAST_FURNACE, TIER2);
        this.customBlastFurnaceLike(MultiFurnaceTieredItems.POWERED_COMPRESSED_BLAST_FURNACE, POWERED_BLAST_FURNACE, TIER);
        this.customBlastFurnaceLike(MultiFurnaceTieredItems.POWERED_DOUBLE_COMPRESSED_BLAST_FURNACE, POWERED_BLAST_FURNACE, TIER1);
        this.customBlastFurnaceLike(MultiFurnaceTieredItems.POWERED_TRIPLE_COMPRESSED_BLAST_FURNACE, POWERED_BLAST_FURNACE, TIER2);
    }

    private void customFurnaceLike(DeferredHolder<Block, ? extends Block> block, String type, String tier) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            Direction facing = (Direction)state.getValue((Property)AbstractCompressedBlock.FACING);
            int xRotation = 0;
            int yRotation = switch (facing) {
                case Direction.SOUTH -> 180;
                case Direction.WEST -> 270;
                case Direction.EAST -> 90;
                default -> 0;
            };
            if (((Boolean)state.getValue((Property)AbstractCompressedBlock.LIT)).booleanValue()) {
                return new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().orientable(tier + "_" + type + "_on", ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("block/" + tier + "_furnace_side")), ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("block/" + tier + "_" + type + "_front_on")), ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("block/" + tier + "_furnace_top"))), xRotation, yRotation, false)};
            }
            return new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().orientable(tier + "_" + type, ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("block/" + tier + "_furnace_side")), ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("block/" + tier + "_" + type + "_front")), ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("block/" + tier + "_furnace_top"))), xRotation, yRotation, false)};
        });
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().orientable(tier + "_" + type, ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("block/" + tier + "_furnace_side")), ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("block/" + tier + "_" + type + "_front")), ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("block/" + tier + "_furnace_top"))));
    }

    private void customBlastFurnaceLike(DeferredHolder<Block, ? extends Block> block, String type, String tier) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            Direction facing = (Direction)state.getValue((Property)AbstractCompressedBlock.FACING);
            int xRotation = 0;
            int yRotation = switch (facing) {
                case Direction.SOUTH -> 180;
                case Direction.WEST -> 270;
                case Direction.EAST -> 90;
                default -> 0;
            };
            if (((Boolean)state.getValue((Property)AbstractCompressedBlock.LIT)).booleanValue()) {
                return new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().orientable(tier + "_" + type + "_on", ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("block/" + tier + "_blast_furnace_side")), ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("block/" + tier + "_" + type + "_front_on")), ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("block/" + tier + "_blast_furnace_top"))), xRotation, yRotation, false)};
            }
            return new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().orientable(tier + "_" + type, ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("block/" + tier + "_blast_furnace_side")), ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("block/" + tier + "_" + type + "_front")), ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("block/" + tier + "_blast_furnace_top"))), xRotation, yRotation, false)};
        });
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().orientable(tier + "_" + type, ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("block/" + tier + "_blast_furnace_side")), ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("block/" + tier + "_" + type + "_front")), ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("block/" + tier + "_blast_furnace_top"))));
    }
}

