/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.data;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.biorfn.compressedfurnace.data.EnUsLangProvider;
import net.biorfn.compressedfurnace.data.MultiFurnaceBlackStateProvider;
import net.biorfn.compressedfurnace.data.MultiFurnaceBlockLootTableProvider;
import net.biorfn.compressedfurnace.data.MultiFurnaceBlockTagProvider;
import net.biorfn.compressedfurnace.data.MultiFurnaceItemsModelProvider;
import net.biorfn.compressedfurnace.data.MultiFurnaceRecipeProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="compressedfurnace", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(MultiFurnaceBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new MultiFurnaceRecipeProvider(packOutput, lookupProvider));
        MultiFurnaceBlockTagProvider blockTagsProvider = new MultiFurnaceBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeClient(), (DataProvider)new MultiFurnaceItemsModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new EnUsLangProvider(packOutput, "en_us"));
        generator.addProvider(event.includeClient(), (DataProvider)new MultiFurnaceBlackStateProvider(packOutput, existingFileHelper));
    }
}

