/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.config;

import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="compressedfurnace", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static ModConfigSpec.IntValue compressedEnergyPerTick;
    public static ModConfigSpec.IntValue compressedEnergyCapacity;
    public static ModConfigSpec.IntValue compressedMaxTransferRate;
    public static ModConfigSpec.IntValue doubleCompressedEnergyPerTick;
    public static ModConfigSpec.IntValue doubleCompressedEnergyCapacity;
    public static ModConfigSpec.IntValue doubleCompressedMaxTransferRate;
    public static ModConfigSpec.IntValue tripleCompressedEnergyPerTick;
    public static ModConfigSpec.IntValue tripleCompressedEnergyCapacity;
    public static ModConfigSpec.IntValue tripleCompressedMaxTransferRate;
    public static ModConfigSpec.DoubleValue compressedCookTimeModifier;
    public static ModConfigSpec.DoubleValue compressedFuelMultiplier;
    public static ModConfigSpec.DoubleValue doubleCompressedCookTimeModifier;
    public static ModConfigSpec.DoubleValue doubleCompressedFuelMultiplier;
    public static ModConfigSpec.DoubleValue tripleCompressedCookTimeModifier;
    public static ModConfigSpec.DoubleValue tripleCompressedFuelMultiplier;
    public static ModConfigSpec.ConfigValue<List<? extends Double>> compressedChances;
    public static ModConfigSpec.ConfigValue<List<? extends Double>> doubleCompressedChances;
    public static ModConfigSpec.ConfigValue<List<? extends Double>> tripleCompressedChances;
    public static ModConfigSpec.IntValue compressedLavaTankCapacity;
    public static ModConfigSpec.IntValue doubleCompressedLavaTankCapacity;
    public static ModConfigSpec.IntValue tripleCompressedLavaTankCapacity;
    public static final ModConfigSpec SPEC;

    static void extraItems() {
        BUILDER.comment("Extar Items List").push("extra_items");
        BUILDER.comment("Compressed Tier Settings").push("compressed");
        compressedChances = BUILDER.comment("Chance list for extra items in compressed tier.").defineList("compressedChances", List.of(Double.valueOf(0.125)), obj -> obj instanceof Double);
        BUILDER.pop();
        BUILDER.comment("Double Compressed Tier Settings").push("doubleCompressed");
        doubleCompressedChances = BUILDER.comment("Chance list for extra items in double compressed tier.").defineList("doubleCompressedChances", List.of(Double.valueOf(0.125), Double.valueOf(0.25)), obj -> obj instanceof Double);
        BUILDER.pop();
        BUILDER.comment("Triple Compressed Tier Settings").push("tripleCompressed");
        tripleCompressedChances = BUILDER.comment("Chance list for extra items in triple compressed tier.").defineList("tripleCompressedChances", List.of(Double.valueOf(0.125), Double.valueOf(0.25), Double.valueOf(0.5)), obj -> obj instanceof Double);
        BUILDER.pop(2);
    }

    static void cookinAndFuel() {
        BUILDER.comment("Cooking Time Modifiers").push("cooking");
        compressedCookTimeModifier = BUILDER.comment("Cooking time modifier for compressed tier (e.g., 0.9 for 10% faster cooking).").defineInRange("compressedCookTimeModifier", 0.9, 0.01, 10.0);
        doubleCompressedCookTimeModifier = BUILDER.comment("Cooking time modifier for double compressed tier (e.g., 0.8 for 20% faster cooking).").defineInRange("doubleCompressedCookTimeModifier", 0.8, 0.01, 10.0);
        tripleCompressedCookTimeModifier = BUILDER.comment("Cooking time modifier for triple compressed tier (e.g., 0.6 for 40% faster cooking).").defineInRange("tripleCompressedCookTimeModifier", 0.6, 0.01, 10.0);
        BUILDER.pop(1);
        BUILDER.comment("Fuel Efficiency Multipliers").push("fuel");
        compressedFuelMultiplier = BUILDER.comment("Fuel efficiency multiplier for compressed tier furnaces (e.g., 1.5 means burn time is 1.5x more efficient).").defineInRange("compressedFuelMultiplier", 1.5, 0.1, 10.0);
        doubleCompressedFuelMultiplier = BUILDER.comment("Fuel efficiency multiplier for double compressed tier furnaces (e.g., 2.0 means burn time is 2x more efficient).").defineInRange("doubleCompressedFuelMultiplier", 2.0, 0.1, 10.0);
        tripleCompressedFuelMultiplier = BUILDER.comment("Fuel efficiency multiplier for triple compressed tier furnaces (e.g., 2.5 means burn time is 2.5x more efficient).").defineInRange("tripleCompressedFuelMultiplier", 2.5, 0.1, 10.0);
        BUILDER.pop(1);
    }

    static void energy() {
        BUILDER.comment("Energy Capacity and TransferRate Configuration").push("energy");
        BUILDER.comment("Compressed Tier Settings").push("compressed");
        compressedEnergyCapacity = BUILDER.comment("Energy capacity for compressed tiers.").defineInRange("compressedEnergyCapacity", 5000, 1, Integer.MAX_VALUE);
        compressedMaxTransferRate = BUILDER.comment("Max energy transfer rate (FE/t) for compressed tiers.").defineInRange("compressedMaxTransferRate", 500, 1, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.comment("Double Compressed").push("doubleCompressed");
        doubleCompressedEnergyCapacity = BUILDER.comment("Energy capacity for double compressed tier generators.").defineInRange("doubleCompressedEnergyCapacity", 20000, 1, Integer.MAX_VALUE);
        doubleCompressedMaxTransferRate = BUILDER.comment("Max energy transfer rate (FE/t) for double compressed tier generators.").defineInRange("doubleCompressedMaxTransferRate", 1000, 1, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.comment("Triple Compressed").push("tripleCompressed");
        tripleCompressedEnergyCapacity = BUILDER.comment("Energy capacity for triple compressed tier generators.").defineInRange("tripleCompressedEnergyCapacity", 200000, 1, Integer.MAX_VALUE);
        tripleCompressedMaxTransferRate = BUILDER.comment("Max energy transfer rate (FE/t) for triple compressed tier generators.").defineInRange("tripleCompressedMaxTransferRate", 2000, 1, Integer.MAX_VALUE);
        BUILDER.pop(2);
        BUILDER.comment("Generator Configuration").push("generator");
        BUILDER.comment("Compressed Tier Settings").push("compressed");
        compressedEnergyPerTick = BUILDER.comment("Energy produced per tick by compressed tier generators.").defineInRange("compressedEnergyPerTick", 10, 1, Integer.MAX_VALUE);
        compressedLavaTankCapacity = BUILDER.comment("Lava tank capacity for compressed tier generators.").defineInRange("compressedLavaTankCapacity", 5000, 100, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.comment("Double Compressed Tier Settings").push("doubleCompressed");
        doubleCompressedEnergyPerTick = BUILDER.comment("Energy produced per tick by double compressed tier generators.").defineInRange("doubleCompressedEnergyPerTick", 40, 1, Integer.MAX_VALUE);
        doubleCompressedLavaTankCapacity = BUILDER.comment("Lava tank capacity for double compressed tier generators.").defineInRange("doubleCompressedLavaTankCapacity", 10000, 100, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.comment("Triple Compressed Tier Settings").push("tripleCompressed");
        tripleCompressedEnergyPerTick = BUILDER.comment("Energy produced per tick by triple compressed tier generators.").defineInRange("tripleCompressedEnergyPerTick", 80, 1, Integer.MAX_VALUE);
        tripleCompressedLavaTankCapacity = BUILDER.comment("Lava tank capacity for triple compressed tier generators.").defineInRange("tripleCompressedLavaTankCapacity", 200000, 100, Integer.MAX_VALUE);
        BUILDER.pop(2);
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
    }

    static {
        Config.energy();
        Config.cookinAndFuel();
        Config.extraItems();
        SPEC = BUILDER.build();
    }
}

