/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.blocks.powered.blast;

import com.mojang.serialization.MapCodec;
import net.biorfn.compressedfurnace.blocks.powered.AbstractCompressedPoweredBlock;
import net.biorfn.compressedfurnace.entity.powered.blast.PoweredTripleCompressedBlastFurnaceBlockEntity;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.minecraft.core.BlockPos;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PoweredTripleCompressedBlastFurnaceBlock
extends AbstractCompressedPoweredBlock {
    public static final String ID = "powered_triple_compressed_blast_furnace";
    public static final MapCodec<PoweredTripleCompressedBlastFurnaceBlock> CODEC = PoweredTripleCompressedBlastFurnaceBlock.simpleCodec(PoweredTripleCompressedBlastFurnaceBlock::new);

    protected MapCodec<? extends PoweredTripleCompressedBlastFurnaceBlock> codec() {
        return CODEC;
    }

    public PoweredTripleCompressedBlastFurnaceBlock(BlockBehaviour.Properties properties) {
        super(properties, "blast", true);
    }

    @Override
    protected void openContainer(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PoweredTripleCompressedBlastFurnaceBlockEntity) {
            PoweredTripleCompressedBlastFurnaceBlockEntity poweredTripleCompressedBlastFurnaceBlockEntity = (PoweredTripleCompressedBlastFurnaceBlockEntity)blockEntity;
            player.openMenu((MenuProvider)poweredTripleCompressedBlastFurnaceBlockEntity);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new PoweredTripleCompressedBlastFurnaceBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return PoweredTripleCompressedBlastFurnaceBlock.createPoweredTicker(level, blockEntityType, MultiFurnaceTieredItems.POWERED_TRIPLE_COMPRESSED_BLAST_FURNACE_TILE.get());
    }
}

