/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.blocks.powered.blast;

import com.mojang.serialization.MapCodec;
import net.biorfn.compressedfurnace.blocks.powered.AbstractCompressedPoweredBlock;
import net.biorfn.compressedfurnace.entity.powered.blast.PoweredCompressedBlastFurnaceBlockEntity;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PoweredCompressedBlastFurnaceBlock
extends AbstractCompressedPoweredBlock {
    public static final String ID = "powered_compressed_blast_furnace";
    public static final MapCodec<PoweredCompressedBlastFurnaceBlock> CODEC = PoweredCompressedBlastFurnaceBlock.simpleCodec(PoweredCompressedBlastFurnaceBlock::new);

    protected MapCodec<? extends PoweredCompressedBlastFurnaceBlock> codec() {
        return CODEC;
    }

    public PoweredCompressedBlastFurnaceBlock(BlockBehaviour.Properties properties) {
        super(properties, "blast", true);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new PoweredCompressedBlastFurnaceBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return PoweredCompressedBlastFurnaceBlock.createPoweredTicker(level, blockEntityType, MultiFurnaceTieredItems.POWERED_COMPRESSED_BLAST_FURNACE_TILE.get());
    }

    @Override
    protected void openContainer(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PoweredCompressedBlastFurnaceBlockEntity) {
            PoweredCompressedBlastFurnaceBlockEntity poweredCompressedBlastFurnaceBlockEntity = (PoweredCompressedBlastFurnaceBlockEntity)blockEntity;
            player.openMenu((MenuProvider)poweredCompressedBlastFurnaceBlockEntity);
            player.awardStat(Stats.INTERACT_WITH_BLAST_FURNACE);
        }
    }
}

