/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.blocks.powered;

import java.util.ArrayList;
import java.util.List;
import net.biorfn.compressedfurnace.blocks.AbstractCompressedBlock;
import net.biorfn.compressedfurnace.entity.powered.AbstractCompressedPoweredEntityBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCompressedPoweredBlock
extends AbstractCompressedBlock {
    public AbstractCompressedPoweredBlock(BlockBehaviour.Properties properties, String type, boolean isPowered) {
        super(properties, type, isPowered);
    }

    @Override
    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (blockentity instanceof AbstractCompressedPoweredEntityBlock) {
                AbstractCompressedPoweredEntityBlock abstractCompressedEntityBlock = (AbstractCompressedPoweredEntityBlock)blockentity;
                if (level instanceof ServerLevel) {
                    Containers.dropContents((Level)level, (BlockPos)pos, (Container)abstractCompressedEntityBlock);
                    abstractCompressedEntityBlock.getRecipesToAwardAndPopExperience((ServerLevel)level, Vec3.atCenterOf((Vec3i)pos));
                }
                super.onRemove(state, level, pos, newState, isMoving);
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            } else {
                super.onRemove(state, level, pos, newState, isMoving);
            }
        }
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createPoweredTicker(Level level, BlockEntityType<T> serverType, BlockEntityType<? extends AbstractCompressedPoweredEntityBlock> clientType) {
        return level.isClientSide ? null : AbstractCompressedPoweredBlock.createTickerHelper(serverType, clientType, AbstractCompressedPoweredEntityBlock::serverTick);
    }

    @Override
    protected BlockState getBlockBeingCrushed(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractCompressedPoweredEntityBlock) {
            AbstractCompressedPoweredEntityBlock blockEntity2 = (AbstractCompressedPoweredEntityBlock)blockEntity;
            ArrayList<BlockState> possibleParticles = new ArrayList<BlockState>();
            for (int inputSlot : blockEntity2.SLOTS_FOR_INPUT) {
                Block block;
                ItemStack inputStack = (ItemStack)blockEntity2.items.get(inputSlot);
                if (inputStack.isEmpty() || (block = Block.byItem((Item)inputStack.getItem())) == Blocks.AIR) continue;
                possibleParticles.add(block.defaultBlockState());
            }
            if (!possibleParticles.isEmpty()) {
                return (BlockState)possibleParticles.get(level.random.nextInt(possibleParticles.size()));
            }
        }
        return FALLBACK_BLOCK_STATE;
    }

    @Override
    protected void spawnParticleEffects(Level level, BlockState state, BlockPos pos, RandomSource random) {
        double x = (double)pos.getX() + 0.5;
        double y = pos.getY();
        double z = (double)pos.getZ() + 0.5;
        Direction direction = (Direction)state.getValue((Property)FACING);
        for (ParticleType particleType : List.of(ParticleTypes.SMOKE)) {
            this.spawnDirectionalParticle(level, direction, random, x, y, z, particleType);
        }
        this.spawnCrushingParticle(level, state, pos, random);
    }

    @Override
    protected void spawnDirectionalParticle(Level level, Direction direction, RandomSource random, double x, double y, double z, ParticleType<?> particleType) {
        double xOffset = direction.getAxis() == Direction.Axis.X ? (double)direction.getStepX() * 0.6 : random.nextDouble() * 0.6 - 0.3;
        double zOffset = direction.getAxis() == Direction.Axis.Z ? (double)direction.getStepZ() * 0.6 : random.nextDouble() * 0.6 - 0.3;
        double heightOffset = random.nextDouble() * 6.0 / 16.0;
        this.addBlockParticle(level, particleType, x + xOffset, y + heightOffset, z + zOffset);
    }
}

