/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.blocks.generator;

import com.mojang.serialization.MapCodec;
import net.biorfn.compressedfurnace.blocks.generator.GeneratorBlock;
import net.biorfn.compressedfurnace.entity.generator.TripleCompressedGeneratorEntity;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.minecraft.core.BlockPos;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TripleCompressedGeneratorBlock
extends GeneratorBlock {
    public static final String ID = "triple_compressed_generator";
    public static final MapCodec<TripleCompressedGeneratorBlock> CODEC = TripleCompressedGeneratorBlock.simpleCodec(TripleCompressedGeneratorBlock::new);

    @Override
    protected MapCodec<? extends GeneratorBlock> codec() {
        return CODEC;
    }

    public TripleCompressedGeneratorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new TripleCompressedGeneratorEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return TripleCompressedGeneratorBlock.createGeneratorTicker(level, blockEntityType, MultiFurnaceTieredItems.TRIPLE_COMPRESSED_GENERATOR_TILE.get());
    }

    @Override
    protected void openContainer(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TripleCompressedGeneratorEntity) {
            TripleCompressedGeneratorEntity tripleCompressedGeneratorEntity = (TripleCompressedGeneratorEntity)blockEntity;
            player.openMenu((MenuProvider)tripleCompressedGeneratorEntity);
        }
    }
}

