/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.blocks.generator;

import com.mojang.serialization.MapCodec;
import net.biorfn.compressedfurnace.blocks.generator.GeneratorBlock;
import net.biorfn.compressedfurnace.entity.generator.CompressedGeneratorEntity;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.minecraft.core.BlockPos;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CompressedGeneratorBlock
extends GeneratorBlock {
    public static final String ID = "compressed_generator";
    public static final MapCodec<CompressedGeneratorBlock> CODEC = CompressedGeneratorBlock.simpleCodec(CompressedGeneratorBlock::new);

    protected MapCodec<? extends CompressedGeneratorBlock> codec() {
        return CODEC;
    }

    public CompressedGeneratorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new CompressedGeneratorEntity(blockPos, blockState);
    }

    @Override
    protected void openContainer(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CompressedGeneratorEntity) {
            CompressedGeneratorEntity compressedGeneratorEntity = (CompressedGeneratorEntity)blockEntity;
            player.openMenu((MenuProvider)compressedGeneratorEntity);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return CompressedGeneratorBlock.createGeneratorTicker(level, blockEntityType, MultiFurnaceTieredItems.COMPRESSED_GENERATOR_TILE.get());
    }
}

