/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.blocks.crusher;

import com.mojang.serialization.MapCodec;
import net.biorfn.compressedfurnace.blocks.AbstractCompressedBlock;
import net.biorfn.compressedfurnace.entity.crusher.CompressedCrusherEntity;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.minecraft.core.BlockPos;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CompressedCrusherBlock
extends AbstractCompressedBlock {
    public static final MapCodec<CompressedCrusherBlock> CODEC = CompressedCrusherBlock.simpleCodec(CompressedCrusherBlock::new);
    public static final String ID = "compressed_crusher";

    protected MapCodec<CompressedCrusherBlock> codec() {
        return CODEC;
    }

    public CompressedCrusherBlock(BlockBehaviour.Properties properties) {
        super(properties, "crusher", false);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new CompressedCrusherEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return CompressedCrusherBlock.createTicker(level, blockEntityType, MultiFurnaceTieredItems.COMPRESSED_CRUSHER_TILE.get());
    }

    @Override
    protected void openContainer(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CompressedCrusherEntity) {
            CompressedCrusherEntity compressedCrusherEntity = (CompressedCrusherEntity)blockEntity;
            player.openMenu((MenuProvider)compressedCrusherEntity);
        }
    }
}

