/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.blocks.blast;

import com.mojang.serialization.MapCodec;
import net.biorfn.compressedfurnace.blocks.AbstractCompressedBlock;
import net.biorfn.compressedfurnace.entity.blast.TripleCompressedBlastFurnaceEntity;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TripleCompressedBlastFurnaceBlock
extends AbstractCompressedBlock {
    public static final MapCodec<TripleCompressedBlastFurnaceBlock> CODEC = TripleCompressedBlastFurnaceBlock.simpleCodec(TripleCompressedBlastFurnaceBlock::new);
    public static final String ID = "triple_compressed_blast_furnace";

    protected MapCodec<TripleCompressedBlastFurnaceBlock> codec() {
        return CODEC;
    }

    public TripleCompressedBlastFurnaceBlock(BlockBehaviour.Properties properties) {
        super(properties, "blast", false);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new TripleCompressedBlastFurnaceEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return TripleCompressedBlastFurnaceBlock.createTicker(level, blockEntityType, MultiFurnaceTieredItems.TRIPLE_COMPRESSED_BLAST_FURNACE_TILE.get());
    }

    @Override
    protected void openContainer(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TripleCompressedBlastFurnaceEntity) {
            TripleCompressedBlastFurnaceEntity compressedBlastFurnaceEntity = (TripleCompressedBlastFurnaceEntity)blockEntity;
            player.openMenu((MenuProvider)compressedBlastFurnaceEntity);
            player.awardStat(Stats.INTERACT_WITH_BLAST_FURNACE);
        }
    }
}

