/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.blocks.Furnace;

import com.mojang.serialization.MapCodec;
import net.biorfn.compressedfurnace.blocks.AbstractCompressedBlock;
import net.biorfn.compressedfurnace.entity.furnace.DoubleCompressedFurnaceEntity;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class DoubleCompressedFurnaceBlock
extends AbstractCompressedBlock {
    public static final MapCodec<DoubleCompressedFurnaceBlock> CODEC = DoubleCompressedFurnaceBlock.simpleCodec(DoubleCompressedFurnaceBlock::new);
    public static final String ID = "double_compressed_furnace";

    protected MapCodec<DoubleCompressedFurnaceBlock> codec() {
        return CODEC;
    }

    public DoubleCompressedFurnaceBlock(BlockBehaviour.Properties properties) {
        super(properties, "furnace", false);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new DoubleCompressedFurnaceEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return DoubleCompressedFurnaceBlock.createTicker(level, blockEntityType, MultiFurnaceTieredItems.DOUBLE_COMPRESSED_FURNACE_TILE.get());
    }

    @Override
    protected void openContainer(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DoubleCompressedFurnaceEntity) {
            DoubleCompressedFurnaceEntity compressedFurnaceEntity = (DoubleCompressedFurnaceEntity)blockEntity;
            player.openMenu((MenuProvider)compressedFurnaceEntity);
            player.awardStat(Stats.INTERACT_WITH_FURNACE);
        }
    }
}

