/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.events;

import java.util.function.BooleanSupplier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.config.ITorchmasterConfig;
import net.xalcon.torchmaster.events.EventResult;
import net.xalcon.torchmaster.events.EventResultContainer;
import net.xalcon.torchmaster.platform.Services;

public class TorchmasterEventHandler {
    private static boolean isIntentionalSpawn(MobSpawnType spawnType) {
        switch (spawnType) {
            case BREEDING: 
            case DISPENSER: 
            case BUCKET: 
            case CONVERSION: 
            case SPAWN_EGG: 
            case TRIGGERED: 
            case COMMAND: 
            case EVENT: {
                return true;
            }
        }
        return false;
    }

    private static boolean isNaturalSpawn(MobSpawnType spawnType) {
        switch (spawnType) {
            default: {
                return true;
            }
            case BREEDING: 
            case DISPENSER: 
            case BUCKET: 
            case CONVERSION: 
            case SPAWN_EGG: 
            case TRIGGERED: 
            case COMMAND: 
            case EVENT: 
            case SPAWNER: 
            case STRUCTURE: 
            case MOB_SUMMONED: 
            case REINFORCEMENT: 
            case JOCKEY: 
        }
        return false;
    }

    public static void onCheckSpawn(MobSpawnType spawnType, Entity entity, Vec3 location, EventResultContainer container) {
        ITorchmasterConfig config = Services.PLATFORM.getConfig();
        Torchmaster.LOG.debug("CheckSpawn - Reason: {}, Type: {}, Pos: {}/{}/{}", new Object[]{spawnType, EntityType.getKey((EntityType)entity.getType()), location.x, location.y, location.z});
        if (TorchmasterEventHandler.isIntentionalSpawn(spawnType)) {
            return;
        }
        if (!config.getAggressiveSpawnChecks() && container.getResult() == EventResult.ALLOW) {
            return;
        }
        if (config.getBlockOnlyNaturalSpawns() && !TorchmasterEventHandler.isNaturalSpawn(spawnType)) {
            return;
        }
        Level level = entity.getCommandSenderWorld();
        Torchmaster.getRegistryForLevel(level).ifPresent(reg -> {
            if (reg.shouldBlockEntity(entity, entity.getCommandSenderWorld(), spawnType)) {
                container.setResult(EventResult.DENY);
                Torchmaster.LOG.debug("Blocking spawn of {}", (Object)EntityType.getKey((EntityType)entity.getType()));
            } else {
                Torchmaster.LOG.debug("Allowed spawn of {}", (Object)EntityType.getKey((EntityType)entity.getType()));
            }
        });
    }

    public static void onVillageSiege(Level level, Vec3 attemptedSpawnPos, EventResultContainer container) {
        ITorchmasterConfig config = Services.PLATFORM.getConfig();
        if (!config.getBlockVillageSieges()) {
            return;
        }
        Torchmaster.LOG.debug("VillageSiegeEvent - Pos: {}", (Object)attemptedSpawnPos);
        if (!config.getAggressiveSpawnChecks() && container.getResult() == EventResult.ALLOW) {
            return;
        }
        Torchmaster.getRegistryForLevel(level).ifPresent(reg -> {
            if (reg.shouldBlockVillagePillagerSiege(attemptedSpawnPos)) {
                container.setResult(EventResult.DENY);
                Torchmaster.LOG.debug("Blocking village siege @ {}", (Object)attemptedSpawnPos);
            } else {
                Torchmaster.LOG.debug("Allowed village siege @ {}", (Object)attemptedSpawnPos);
            }
        });
    }

    public static void onServerLevelTickEnd(MinecraftServer server, BooleanSupplier haveTime) {
        for (ServerLevel level : server.getAllLevels()) {
            Torchmaster.getRegistryForLevel((Level)level).ifPresent(reg -> reg.onGlobalTick((Level)level));
        }
    }
}

