/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.util.data;

import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class NbtX {
    public static void putResource(CompoundTag nbt, String key, ResourceLocation rl) {
        nbt.putString(key, rl.toString());
    }

    @Nullable
    public static ResourceLocation getResource(CompoundTag nbt, String key) {
        if (nbt.contains(key, 8)) {
            return ResourceLocation.tryParse((String)nbt.getString(key));
        }
        return null;
    }

    public static ResourceLocation getResource(CompoundTag nbt, String key, ResourceLocation defaultValue) {
        ResourceLocation rl = NbtX.getResource(nbt, key);
        return rl == null ? defaultValue : rl;
    }

    public static void putResourceKey(CompoundTag nbt, String key, ResourceKey<?> rl) {
        NbtX.putResource(nbt, key, rl.location());
    }

    @Nullable
    public static <T> ResourceKey<T> getResourceKey(CompoundTag nbt, String key, ResourceKey<Registry<T>> registry) {
        ResourceLocation rl = NbtX.getResource(nbt, key);
        if (rl != null) {
            return ResourceKey.create(registry, (ResourceLocation)rl);
        }
        return null;
    }

    public static <T> ResourceKey<T> getResourceKey(CompoundTag nbt, String key, ResourceKey<Registry<T>> registry, ResourceKey<T> defaultValue) {
        ResourceKey<T> rl = NbtX.getResourceKey(nbt, key, registry);
        return rl == null ? defaultValue : rl;
    }
}

